/*
 * Decompiled with CFR 0.152.
 */
package ca.cutterslade.gradle.analyze.util;

import ca.cutterslade.gradle.analyze.logging.AnalyzeDependenciesLogger;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;

public final class ProjectDependencyResolverUtils {
    private ProjectDependencyResolverUtils() {
    }

    public static Map<File, Set<String>> buildUsedArtifacts(Map<File, Set<String>> artifactClassMap, Collection<String> dependencyClasses) {
        LinkedHashMap<File, Set<String>> map = new LinkedHashMap<File, Set<String>>();
        dependencyClasses.forEach(className -> artifactClassMap.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(className)).findFirst().ifPresent(e -> map.computeIfAbsent((File)e.getKey(), f -> new HashSet()).add(className)));
        return map;
    }

    public static Set<ResolvedArtifact> resolveArtifacts(Collection<Configuration> configurations) {
        return configurations.stream().map(Configuration::getResolvedConfiguration).map(ResolvedConfiguration::getFirstLevelModuleDependencies).flatMap(Collection::stream).map(ResolvedDependency::getAllModuleArtifacts).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static List<ResolvedDependency> getFirstLevelDependencies(Collection<Configuration> configurations) {
        return configurations.stream().map(Configuration::getResolvedConfiguration).map(ResolvedConfiguration::getFirstLevelModuleDependencies).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public static List<File> findModuleArtifactFiles(Collection<ResolvedDependency> dependencies) {
        return dependencies.stream().map(ResolvedDependency::getModuleArtifacts).flatMap(Collection::stream).map(ResolvedArtifact::getFile).distinct().collect(Collectors.toList());
    }

    public static List<File> findAllModuleArtifactFiles(Collection<ResolvedDependency> dependencies) {
        return dependencies.stream().map(ResolvedDependency::getAllModuleArtifacts).flatMap(Collection::stream).map(ResolvedArtifact::getFile).distinct().collect(Collectors.toList());
    }

    public static Map<ResolvedArtifact, Collection<ResolvedArtifact>> used(List<ComponentIdentifier> allDependencyArtifacts, Set<File> usedArtifacts, Map<ResolvedArtifact, Set<ResolvedArtifact>> aggregatorsWithDependencies, AnalyzeDependenciesLogger logger) {
        Map<ResolvedArtifact, Collection<ResolvedArtifact>> usedAggregators = aggregatorsWithDependencies.entrySet().stream().filter(e -> allDependencyArtifacts.contains(((ResolvedArtifact)e.getKey()).getId().getComponentIdentifier())).collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Set filesForAggregator = ((Set)e.getValue()).stream().map(ResolvedArtifact::getFile).distinct().filter(usedArtifacts::contains).collect(Collectors.toSet());
            return ((Set)e.getValue()).stream().filter(f -> filesForAggregator.contains(f.getFile())).collect(Collectors.toSet());
        }));
        return ProjectDependencyResolverUtils.removeDuplicates(usedAggregators, aggregatorsWithDependencies, logger);
    }

    private static Map<ResolvedArtifact, Collection<ResolvedArtifact>> removeDuplicates(Map<ResolvedArtifact, Collection<ResolvedArtifact>> usedAggregators, Map<ResolvedArtifact, Set<ResolvedArtifact>> aggregatorsWithDependencies, AnalyzeDependenciesLogger logger) {
        Map aggregatorsSortedByDependencies = usedAggregators.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingInt(Collection::size)).thenComparing(Map.Entry.comparingByKey(Comparator.comparingInt(k -> ((Set)aggregatorsWithDependencies.get(k)).size()).reversed()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a2, LinkedHashMap::new));
        HashSet aggregatorArtifactAlreadySeen = new HashSet();
        aggregatorsSortedByDependencies.entrySet().removeIf(e -> {
            aggregatorArtifactAlreadySeen.add(e.getKey());
            return aggregatorsSortedByDependencies.entrySet().stream().anyMatch(e2 -> !aggregatorArtifactAlreadySeen.contains(e2.getKey()) && ((Collection)e2.getValue()).containsAll((Collection)e.getValue()));
        });
        logger.info("used aggregators", aggregatorsSortedByDependencies.keySet());
        return aggregatorsSortedByDependencies;
    }

    public static Map<ResolvedArtifact, Set<ResolvedArtifact>> getAggregatorsMapping(Collection<Configuration> allowedAggregatorsToUse) {
        if (allowedAggregatorsToUse.isEmpty()) {
            return Collections.emptyMap();
        }
        Map resolvedArtifacts = ProjectDependencyResolverUtils.resolveArtifacts(allowedAggregatorsToUse).stream().collect(Collectors.toMap(d -> d.getModuleVersion().toString(), Function.identity()));
        List<ResolvedDependency> dependencies = ProjectDependencyResolverUtils.getFirstLevelDependencies(allowedAggregatorsToUse);
        return dependencies.stream().filter(d -> resolvedArtifacts.containsKey(d.getName())).collect(Collectors.toMap(d -> (ResolvedArtifact)resolvedArtifacts.get(d.getName()), ResolvedDependency::getAllModuleArtifacts));
    }

    public static List<Configuration> configureApiHelperConfiguration(Configuration apiHelperConfiguration, Project project, String apiConfigurationName) {
        Configuration apiConfiguration = (Configuration)project.getConfigurations().findByName(apiConfigurationName);
        if (apiConfiguration != null) {
            apiHelperConfiguration.extendsFrom(new Configuration[]{apiConfiguration});
            return Collections.singletonList(apiHelperConfiguration);
        }
        return Collections.emptyList();
    }

    public static <T> Collection<T> removeNulls(Collection<T> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        collection.removeIf(Objects::isNull);
        return collection;
    }
}

