/*
 * Decompiled with CFR 0.152.
 */
package ca.cutterslade.gradle.analyze.util;

import ca.cutterslade.gradle.analyze.DependencyAnalysisException;
import ca.cutterslade.gradle.analyze.ProjectDependencyAnalysisResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.logging.Logger;

public final class ProjectDependencyAnalysisResultHandler {
    private ProjectDependencyAnalysisResultHandler() {
    }

    public static void warnAndLogOrFail(ProjectDependencyAnalysisResult result, boolean warnUsedUndeclared, boolean warnUnusedDeclared, boolean warnCompileOnly, Path logFilePath, Logger logger) throws IOException {
        String unusedDeclaredViolations;
        String usedUndeclaredViolations;
        String combinedViolations;
        String compileOnlyViolations;
        Set<ResolvedArtifact> usedUndeclaredArtifacts = result.getUsedUndeclaredArtifacts();
        Set<ResolvedArtifact> unusedDeclaredArtifacts = result.getUnusedDeclaredArtifacts();
        Set<ResolvedArtifact> possiblyUnusedCompileOnlyArtifacts = result.getPossiblyUnusedCompileOnlyArtifacts();
        String string = compileOnlyViolations = warnCompileOnly ? ProjectDependencyAnalysisResultHandler.getArtifactSummary("compileOnlyDeclaredArtifacts", possiblyUnusedCompileOnlyArtifacts) : "";
        if (!warnCompileOnly) {
            usedUndeclaredArtifacts.removeAll(possiblyUnusedCompileOnlyArtifacts);
        }
        if (!(combinedViolations = (usedUndeclaredViolations = ProjectDependencyAnalysisResultHandler.getArtifactSummary("usedUndeclaredArtifacts", usedUndeclaredArtifacts)).concat(unusedDeclaredViolations = ProjectDependencyAnalysisResultHandler.getArtifactSummary("unusedDeclaredArtifacts", unusedDeclaredArtifacts))).isEmpty()) {
            if (logFilePath != null) {
                Files.createDirectories(logFilePath.getParent(), new FileAttribute[0]);
                Files.newBufferedWriter(logFilePath, new OpenOption[0]).append(combinedViolations.concat(compileOnlyViolations)).close();
            }
            if (!warnUsedUndeclared && !warnUnusedDeclared) {
                throw new DependencyAnalysisException(ProjectDependencyAnalysisResultHandler.foundIssues(combinedViolations.concat(compileOnlyViolations)));
            }
            if (!usedUndeclaredViolations.isEmpty()) {
                if (warnUsedUndeclared) {
                    logger.warn(ProjectDependencyAnalysisResultHandler.foundIssues(usedUndeclaredViolations));
                } else {
                    throw new DependencyAnalysisException(ProjectDependencyAnalysisResultHandler.foundIssues(usedUndeclaredViolations));
                }
            }
            if (!unusedDeclaredViolations.isEmpty()) {
                if (warnUnusedDeclared) {
                    logger.warn(ProjectDependencyAnalysisResultHandler.foundIssues(unusedDeclaredViolations));
                } else {
                    throw new DependencyAnalysisException(ProjectDependencyAnalysisResultHandler.foundIssues(unusedDeclaredViolations));
                }
            }
        }
        if (!compileOnlyViolations.isEmpty()) {
            logger.warn(ProjectDependencyAnalysisResultHandler.foundIssues(compileOnlyViolations));
        }
    }

    private static String getArtifactSummary(String sectionName, Set<ResolvedArtifact> resolvedArtifacts) {
        if (!resolvedArtifacts.isEmpty()) {
            return resolvedArtifacts.stream().sorted(Comparator.comparing(resolvedArtifact -> resolvedArtifact.getModuleVersion().getId().toString())).map(resolvedArtifact -> " - " + resolvedArtifact.getModuleVersion().getId() + (resolvedArtifact.getClassifier() != null ? ":" + resolvedArtifact.getClassifier() : "") + "@" + resolvedArtifact.getExtension()).collect(Collectors.joining("\n", sectionName + "\n", "")) + "\n";
        }
        return "";
    }

    private static String foundIssues(String issues) {
        return "Dependency analysis found issues.\n" + issues;
    }
}

