/*
 * Decompiled with CFR 0.152.
 */
package ca.cutterslade.gradle.analyze.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.codehaus.plexus.util.DirectoryScanner;

public final class ClassFileCollectorUtil {
    private static final String classSuffix = ".class";
    private static final String[] CLASS_INCLUDES = new String[]{"**/*.class"};

    private ClassFileCollectorUtil() {
    }

    public static Set<String> collectFromFile(File file) throws IOException {
        HashSet<String> classFiles = new HashSet<String>();
        if (file.getPath().endsWith(".jar") || file.getPath().endsWith(".nar")) {
            ClassFileCollectorUtil.collectFormJar(file, classFiles);
        } else if (file.isDirectory()) {
            ClassFileCollectorUtil.collectFromDirectory(file, classFiles);
        } else if (file.exists()) {
            throw new IllegalArgumentException("Unsupported file for collecting classes: " + file.getPath());
        }
        return classFiles;
    }

    private static void collectFormJar(File jarFile, Set<String> classFiles) throws IOException {
        try (FileInputStream fis = new FileInputStream(jarFile);
             JarInputStream jis = new JarInputStream(fis);){
            JarEntry entry;
            while ((entry = jis.getNextJarEntry()) != null) {
                ClassFileCollectorUtil.addToClassFilesIfMatches(entry.getName(), classFiles);
            }
        }
    }

    private static void collectFromDirectory(File directory, Set<String> classFiles) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(CLASS_INCLUDES);
        scanner.scan();
        for (String path : scanner.getIncludedFiles()) {
            path = path.replace(File.separatorChar, '/');
            ClassFileCollectorUtil.addToClassFilesIfMatches(path, classFiles);
        }
    }

    private static void addToClassFilesIfMatches(String fullQualifiedName, Set<String> classFiles) {
        if (fullQualifiedName.endsWith(classSuffix) && fullQualifiedName.indexOf(45) == -1) {
            classFiles.add(fullQualifiedName.substring(0, fullQualifiedName.length() - classSuffix.length()).replace('/', '.'));
        }
    }
}

