/*
 * Decompiled with CFR 0.152.
 */
package ca.cutterslade.gradle.analyze.logging;

import ca.cutterslade.gradle.analyze.ProjectDependencyAnalysisResult;
import ca.cutterslade.gradle.analyze.logging.AnalyzeDependenciesFileLogger;
import ca.cutterslade.gradle.analyze.logging.AnalyzeDependenciesStandardLogger;
import groovy.lang.Closure;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.gradle.api.logging.Logger;

public abstract class AnalyzeDependenciesLogger {
    public abstract void info(String var1);

    public abstract void info(String var1, Collection<?> var2);

    public abstract void info(String var1, Map<File, Set<String>> var2);

    public static ProjectDependencyAnalysisResult create(Logger gradleLogger, Path logFilePath, @ClosureParams(value=SimpleType.class, options={"ca.cutterslade.gradle.analyze.logging.AnalyzeDependenciesLogger"}) Closure<ProjectDependencyAnalysisResult> withLogger) {
        if (logFilePath != null) {
            try (AnalyzeDependenciesFileLogger logger = new AnalyzeDependenciesFileLogger(logFilePath);){
                ProjectDependencyAnalysisResult projectDependencyAnalysisResult = (ProjectDependencyAnalysisResult)withLogger.call((Object)logger);
                return projectDependencyAnalysisResult;
            }
        }
        AnalyzeDependenciesStandardLogger logger = new AnalyzeDependenciesStandardLogger(gradleLogger);
        return (ProjectDependencyAnalysisResult)withLogger.call((Object)logger);
    }
}

