/*
 * Decompiled with CFR 0.152.
 */
package ca.cutterslade.gradle.analyze.logging;

import ca.cutterslade.gradle.analyze.logging.AnalyzeDependenciesLogger;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AnalyzeDependenciesFileLogger
extends AnalyzeDependenciesLogger
implements AutoCloseable {
    private final PrintWriter writer;

    public AnalyzeDependenciesFileLogger(Path logFilePath) {
        try {
            Files.createDirectories(logFilePath.getParent(), new FileAttribute[0]);
            this.writer = new PrintWriter(Files.newOutputStream(logFilePath, new OpenOption[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("unable to create file for logging", e);
        }
    }

    @Override
    public void info(String title) {
        this.writer.println(title.trim());
        this.writer.println();
    }

    @Override
    public void info(String title, Collection<?> files) {
        this.writer.println(title.trim());
        files.stream().filter(Objects::nonNull).map(f -> f instanceof File ? ((File)f).getName() : f.toString()).map(s -> "- " + s).sorted().forEach(this.writer::println);
        this.writer.println();
    }

    @Override
    public void info(String title, Map<File, Set<String>> fileMap) {
        this.writer.println(title.trim());
        fileMap.entrySet().stream().sorted(Comparator.comparing(e -> ((File)e.getKey()).getName())).forEach(e -> {
            this.writer.println("- " + ((File)e.getKey()).getName());
            ((Set)e.getValue()).stream().sorted().map(s -> "  - " + s).forEach(this.writer::println);
        });
        this.writer.println();
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

