/*
 * Decompiled with CFR 0.152.
 */
package ca.cutterslade.gradle.analyze;

import ca.cutterslade.gradle.analyze.ProjectDependencyAnalysisResult;
import ca.cutterslade.gradle.analyze.logging.AnalyzeDependenciesLogger;
import ca.cutterslade.gradle.analyze.util.ClassFileCollectorUtil;
import ca.cutterslade.gradle.analyze.util.ProjectDependencyResolverUtils;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.maven.shared.dependency.analyzer.DependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.asm.ASMDependencyAnalyzer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.logging.Logger;

public class ProjectDependencyResolver
implements GroovyObject {
    private static final String CACHE_NAME = "ca.cutterslade.gradle.analyze.ProjectDependencyResolver.artifactClassCache";
    private final DependencyAnalyzer dependencyAnalyzer;
    private final ConcurrentHashMap<File, Set<String>> artifactClassCache;
    private final Logger logger;
    private final List<Configuration> require;
    private final List<Configuration> compileOnly;
    private final List<Configuration> api;
    private final List<Configuration> allowedToUse;
    private final List<Configuration> allowedToDeclare;
    private final Iterable<File> classesDirs;
    private final Map<ResolvedArtifact, Set<ResolvedArtifact>> aggregatorsWithDependencies;
    private final List<Configuration> allowedAggregatorsToUse;
    private final Path logFilePath;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ProjectDependencyResolver(Project project, List<Configuration> require, List<Configuration> compileOnly, List<Configuration> apiHelperConfiguration, List<Configuration> allowedToUse, List<Configuration> allowedToDeclare, Iterable<File> classesDirs, List<Configuration> allowedAggregatorsToUse, Path logFilePath) {
        List list;
        List list2;
        List list3;
        List list4;
        Logger logger;
        Path path;
        MetaClass metaClass;
        ASMDependencyAnalyzer aSMDependencyAnalyzer = new ASMDependencyAnalyzer();
        this.dependencyAnalyzer = aSMDependencyAnalyzer;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.logFilePath = path = logFilePath;
        this.logger = logger = project.getLogger();
        this.require = list4 = (List)ScriptBytecodeAdapter.asType(ProjectDependencyResolverUtils.removeNulls(require), List.class);
        List<Configuration> list5 = compileOnly;
        this.compileOnly = list5;
        List<Configuration> list6 = apiHelperConfiguration;
        this.api = list6;
        this.allowedAggregatorsToUse = list3 = (List)ScriptBytecodeAdapter.asType(ProjectDependencyResolverUtils.removeNulls(allowedAggregatorsToUse), List.class);
        this.allowedToUse = list2 = (List)ScriptBytecodeAdapter.asType(ProjectDependencyResolverUtils.removeNulls(allowedToUse), List.class);
        this.allowedToDeclare = list = (List)ScriptBytecodeAdapter.asType(ProjectDependencyResolverUtils.removeNulls(allowedToDeclare), List.class);
        Iterable<File> iterable = classesDirs;
        this.classesDirs = iterable;
        Map<ResolvedArtifact, Set<ResolvedArtifact>> map = ProjectDependencyResolverUtils.getAggregatorsMapping(this.allowedAggregatorsToUse);
        this.aggregatorsWithDependencies = map;
        try {
            ConcurrentHashMap concurrentHashMap;
            this.artifactClassCache = concurrentHashMap = (ConcurrentHashMap)ScriptBytecodeAdapter.asType((Object)project.getRootProject().getExtensions().getByName(CACHE_NAME), ConcurrentHashMap.class);
        }
        catch (UnknownDomainObjectException e) {
            throw (Throwable)new IllegalStateException("Dependency analysis plugin must also be applied to the root project", e);
        }
    }

    public ProjectDependencyAnalysisResult analyzeDependencies() {
        public final class _analyzeDependencies_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _analyzeDependencies_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public ProjectDependencyAnalysisResult doCall(Object logger) {
                Reference allowedToUseDeps = new Reference(((ProjectDependencyResolver)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ProjectDependencyResolver.class)).getAllowedToUseDependencies());
                List<ResolvedDependency> allowedToDeclareDeps = ((ProjectDependencyResolver)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ProjectDependencyResolver.class)).getAllowedToDeclareDependencies();
                List<ResolvedDependency> requiredDeps = ((ProjectDependencyResolver)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ProjectDependencyResolver.class)).getRequiredDependencies();
                public final class _closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference allowedToUseDeps;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure4(Object _outerInstance, Object _thisObject, Reference allowedToUseDeps) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.allowedToUseDeps = reference = allowedToUseDeps;
                    }

                    public Boolean doCall(Object req) {
                        Reference req2 = new Reference(req);
                        public final class _closure35
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference req;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure35(Object _outerInstance, Object _thisObject, Reference req) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.req = reference = req;
                            }

                            public Boolean doCall(Object allowed) {
                                return ScriptBytecodeAdapter.compareEqual((Object)((ResolvedDependency)this.req.get()).getModule().getId(), (Object)((ResolvedDependency)allowed).getModule().getId());
                            }

                            @Generated
                            public Object getReq() {
                                return this.req.get();
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure35.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        return DefaultGroovyMethods.any((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)this.allowedToUseDeps.get(), Iterable.class)), (Closure)new _closure35((Object)this, this.getThisObject(), req2));
                    }

                    @Generated
                    public Object getAllowedToUseDeps() {
                        return this.allowedToUseDeps.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.removeAll(requiredDeps, (Closure)new _closure4((Object)this, this.getThisObject(), allowedToUseDeps));
                List<File> dependencyArtifacts = ProjectDependencyResolverUtils.findModuleArtifactFiles(requiredDeps);
                ((AnalyzeDependenciesLogger)logger).info("dependencyArtifacts", dependencyArtifacts);
                List<File> allDependencyArtifactFiles = ProjectDependencyResolverUtils.findAllModuleArtifactFiles(requiredDeps);
                ((AnalyzeDependenciesLogger)logger).info("allDependencyArtifacts", allDependencyArtifactFiles);
                Map<File, Set<String>> fileClassMap = ((ProjectDependencyResolver)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ProjectDependencyResolver.class)).buildArtifactClassMap(allDependencyArtifactFiles);
                ((AnalyzeDependenciesLogger)logger).info("fileClassMap", fileClassMap);
                Set<String> dependencyClasses = ((ProjectDependencyResolver)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ProjectDependencyResolver.class)).analyzeClassDependencies();
                ((AnalyzeDependenciesLogger)logger).info("dependencyClasses", dependencyClasses);
                Map<File, Set<String>> usedClassesInArtifacts = ProjectDependencyResolverUtils.buildUsedArtifacts(fileClassMap, dependencyClasses);
                ((AnalyzeDependenciesLogger)logger).info("usedClassesInArtifacts", usedClassesInArtifacts);
                Set<File> usedArtifactFiles = usedClassesInArtifacts.keySet();
                ((AnalyzeDependenciesLogger)logger).info("usedArtifacts", usedArtifactFiles);
                Reference usedDeclaredArtifactFiles = new Reference(new LinkedHashSet<File>(dependencyArtifacts));
                ((LinkedHashSet)usedDeclaredArtifactFiles.get()).retainAll(usedArtifactFiles);
                ((AnalyzeDependenciesLogger)logger).info("usedDeclaredArtifacts", (LinkedHashSet)usedDeclaredArtifactFiles.get());
                Reference usedUndeclaredArtifactFiles = new Reference(new LinkedHashSet<File>(usedArtifactFiles));
                ((LinkedHashSet)usedUndeclaredArtifactFiles.get()).removeAll(dependencyArtifacts);
                ((AnalyzeDependenciesLogger)logger).info("usedUndeclaredArtifacts", (LinkedHashSet)usedUndeclaredArtifactFiles.get());
                Reference unusedDeclaredArtifactFiles = new Reference(new LinkedHashSet<File>(dependencyArtifacts));
                ((LinkedHashSet)unusedDeclaredArtifactFiles.get()).removeAll(usedArtifactFiles);
                ((AnalyzeDependenciesLogger)logger).info("unusedDeclaredArtifacts", (LinkedHashSet)unusedDeclaredArtifactFiles.get());
                Object object = ScriptBytecodeAdapter.getPropertySpreadSafe(_analyzeDependencies_closure1.class, (Object)((List)allowedToUseDeps.get()), (String)"moduleArtifacts");
                Reference allowedToUseArtifacts = new Reference((Object)((Set)ScriptBytecodeAdapter.asType(object != null ? DefaultGroovyMethods.flatten((List)((List)ScriptBytecodeAdapter.castToType((Object)object, List.class))) : null, Set.class)));
                ((AnalyzeDependenciesLogger)logger).info("allowedToUseArtifacts", (Set)allowedToUseArtifacts.get());
                Object object2 = ScriptBytecodeAdapter.getPropertySpreadSafe(_analyzeDependencies_closure1.class, allowedToDeclareDeps, (String)"moduleArtifacts");
                Set allowedToDeclareArtifacts = (Set)ScriptBytecodeAdapter.asType(object2 != null ? DefaultGroovyMethods.flatten((List)((List)ScriptBytecodeAdapter.castToType((Object)object2, List.class))) : null, Set.class);
                ((AnalyzeDependenciesLogger)logger).info("allowedToDeclareArtifacts", allowedToDeclareArtifacts);
                Set<ResolvedArtifact> allArtifacts = ProjectDependencyResolverUtils.resolveArtifacts(((ProjectDependencyResolver)this.getThisObject()).require);
                ((AnalyzeDependenciesLogger)logger).info("allArtifacts", allArtifacts);
                public final class _closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference usedDeclaredArtifactFiles;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure5(Object _outerInstance, Object _thisObject, Reference usedDeclaredArtifactFiles) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.usedDeclaredArtifactFiles = reference = usedDeclaredArtifactFiles;
                    }

                    public Boolean doCall(ResolvedArtifact artifact) {
                        return this.usedDeclaredArtifactFiles.get() == null ? artifact.getFile() == null : DefaultGroovyMethods.isCase((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)this.usedDeclaredArtifactFiles.get(), Collection.class)), (Object)artifact.getFile());
                    }

                    @Generated
                    public Boolean call(ResolvedArtifact artifact) {
                        return this.doCall(artifact);
                    }

                    @Generated
                    public Object getUsedDeclaredArtifactFiles() {
                        return this.usedDeclaredArtifactFiles.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Set usedDeclared = DefaultGroovyMethods.findAll(allArtifacts, (Closure)new _closure5((Object)this, this.getThisObject(), usedDeclaredArtifactFiles));
                ((AnalyzeDependenciesLogger)logger).info("usedDeclared", usedDeclared);
                public final class _closure6
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference usedUndeclaredArtifactFiles;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure6(Object _outerInstance, Object _thisObject, Reference usedUndeclaredArtifactFiles) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.usedUndeclaredArtifactFiles = reference = usedUndeclaredArtifactFiles;
                    }

                    public Boolean doCall(ResolvedArtifact artifact) {
                        return this.usedUndeclaredArtifactFiles.get() == null ? artifact.getFile() == null : DefaultGroovyMethods.isCase((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)this.usedUndeclaredArtifactFiles.get(), Collection.class)), (Object)artifact.getFile());
                    }

                    @Generated
                    public Boolean call(ResolvedArtifact artifact) {
                        return this.doCall(artifact);
                    }

                    @Generated
                    public Object getUsedUndeclaredArtifactFiles() {
                        return this.usedUndeclaredArtifactFiles.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Reference usedUndeclared = new Reference((Object)DefaultGroovyMethods.findAll(allArtifacts, (Closure)new _closure6((Object)this, this.getThisObject(), usedUndeclaredArtifactFiles)));
                ((AnalyzeDependenciesLogger)logger).info("usedUndeclared", (Set)usedUndeclared.get());
                if (DefaultTypeTransformation.booleanUnbox((Object)((Set)allowedToUseArtifacts.get()))) {
                    public final class _closure7
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure7(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public ComponentIdentifier doCall(Object it) {
                            return ((ResolvedArtifact)it).getId().getComponentIdentifier();
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public ComponentIdentifier doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure7.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    Reference allowedToUseComponentIdentifiers = new Reference((Object)DefaultGroovyMethods.collect((Iterable)((Set)allowedToUseArtifacts.get()), (Closure)new _closure7((Object)this, this.getThisObject())));
                    public final class _closure8
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference allowedToUseComponentIdentifiers;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure8(Object _outerInstance, Object _thisObject, Reference allowedToUseComponentIdentifiers) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.allowedToUseComponentIdentifiers = reference = allowedToUseComponentIdentifiers;
                        }

                        public Boolean doCall(Object it) {
                            return ((List)this.allowedToUseComponentIdentifiers.get()).contains(((ResolvedArtifact)it).getId().getComponentIdentifier());
                        }

                        @Generated
                        public Object getAllowedToUseComponentIdentifiers() {
                            return this.allowedToUseComponentIdentifiers.get();
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Boolean doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure8.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    DefaultGroovyMethods.removeAll((Collection)((Set)usedUndeclared.get()), (Closure)new _closure8((Object)this, this.getThisObject(), allowedToUseComponentIdentifiers));
                    ((AnalyzeDependenciesLogger)logger).info("usedUndeclared without allowedToUseArtifacts", (Set)usedUndeclared.get());
                }
                public final class _closure9
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference unusedDeclaredArtifactFiles;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure9(Object _outerInstance, Object _thisObject, Reference unusedDeclaredArtifactFiles) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.unusedDeclaredArtifactFiles = reference = unusedDeclaredArtifactFiles;
                    }

                    public Boolean doCall(ResolvedArtifact artifact) {
                        return this.unusedDeclaredArtifactFiles.get() == null ? artifact.getFile() == null : DefaultGroovyMethods.isCase((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)this.unusedDeclaredArtifactFiles.get(), Collection.class)), (Object)artifact.getFile());
                    }

                    @Generated
                    public Boolean call(ResolvedArtifact artifact) {
                        return this.doCall(artifact);
                    }

                    @Generated
                    public Object getUnusedDeclaredArtifactFiles() {
                        return this.unusedDeclaredArtifactFiles.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure9.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Reference unusedDeclared = new Reference((Object)DefaultGroovyMethods.findAll(allArtifacts, (Closure)new _closure9((Object)this, this.getThisObject(), unusedDeclaredArtifactFiles)));
                ((AnalyzeDependenciesLogger)logger).info("unusedDeclared", (Set)unusedDeclared.get());
                if (DefaultTypeTransformation.booleanUnbox((Object)allowedToDeclareArtifacts)) {
                    public final class _closure10
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure10(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public ComponentIdentifier doCall(Object it) {
                            return ((ResolvedArtifact)it).getId().getComponentIdentifier();
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public ComponentIdentifier doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure10.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    Reference allowedToDeclareComponentIdentifiers = new Reference((Object)DefaultGroovyMethods.collect((Iterable)allowedToDeclareArtifacts, (Closure)new _closure10((Object)this, this.getThisObject())));
                    public final class _closure11
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference allowedToDeclareComponentIdentifiers;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure11(Object _outerInstance, Object _thisObject, Reference allowedToDeclareComponentIdentifiers) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.allowedToDeclareComponentIdentifiers = reference = allowedToDeclareComponentIdentifiers;
                        }

                        public Boolean doCall(Object it) {
                            return ((List)this.allowedToDeclareComponentIdentifiers.get()).contains(((ResolvedArtifact)it).getId().getComponentIdentifier());
                        }

                        @Generated
                        public Object getAllowedToDeclareComponentIdentifiers() {
                            return this.allowedToDeclareComponentIdentifiers.get();
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Boolean doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure11.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    DefaultGroovyMethods.removeAll((Collection)((Set)unusedDeclared.get()), (Closure)new _closure11((Object)this, this.getThisObject(), allowedToDeclareComponentIdentifiers));
                    ((AnalyzeDependenciesLogger)logger).info("unusedDeclared without allowedToDeclareArtifacts", (Set)unusedDeclared.get());
                }
                public final class _closure12
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure12(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Set<ResolvedArtifact> doCall(Object it) {
                        return ((ResolvedDependency)it).getAllModuleArtifacts();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Set<ResolvedArtifact> doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure12.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Set allDependencyArtifacts = (Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.flatten((List)DefaultGroovyMethods.collect(requiredDeps, (Closure)new _closure12((Object)this, this.getThisObject()))), Set.class);
                if (!((ProjectDependencyResolver)this.getThisObject()).aggregatorsWithDependencies.isEmpty()) {
                    public final class _closure13
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure13(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public ComponentIdentifier doCall(Object it) {
                            return ((ResolvedArtifact)it).getId().getComponentIdentifier();
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public ComponentIdentifier doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure13.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    List usedIdentifiers = DefaultGroovyMethods.collect((Iterable)allDependencyArtifacts, (Closure)new _closure13((Object)this, this.getThisObject()));
                    public final class _closure14
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure14(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Boolean doCall(Object it) {
                            return ((Collection)((Map.Entry)it).getValue()).isEmpty();
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Boolean doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure14.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    Map aggregatorUsage = DefaultGroovyMethods.groupBy(ProjectDependencyResolverUtils.used(usedIdentifiers, usedArtifactFiles, ((ProjectDependencyResolver)this.getThisObject()).aggregatorsWithDependencies, (AnalyzeDependenciesLogger)ScriptBytecodeAdapter.castToType((Object)logger, AnalyzeDependenciesLogger.class)), (Closure)new _closure14((Object)this, this.getThisObject()));
                    if (aggregatorUsage.containsKey(true)) {
                        Set unusedAggregatorArtifacts = ((Map)aggregatorUsage.get(true)).keySet();
                        public final class _closure15
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure15(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Set<ResolvedArtifact> doCall(Object it) {
                                return ((ResolvedDependency)it).getAllModuleArtifacts();
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Set<ResolvedArtifact> doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure15.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        Set set = DefaultGroovyMethods.plus((Set)((Set)unusedDeclared.get()), (Collection)DefaultGroovyMethods.intersect(unusedAggregatorArtifacts, (Iterable)((Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.flatten((List)DefaultGroovyMethods.collect(requiredDeps, (Closure)new _closure15((Object)this, this.getThisObject()))), Set.class))));
                        unusedDeclared.set((Object)set);
                    }
                    if (aggregatorUsage.containsKey(false)) {
                        Set set;
                        Map usedAggregator = (Map)ScriptBytecodeAdapter.castToType(aggregatorUsage.get(false), Map.class);
                        Set usedAggregatorDependencies = usedAggregator.keySet();
                        public final class _closure16
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure16(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Integer doCall(ResolvedArtifact a, ResolvedArtifact b) {
                                return ScriptBytecodeAdapter.compareEqual((Object)a.getId().getComponentIdentifier(), (Object)b.getId().getComponentIdentifier()) ? 0 : (a.getId().getComponentIdentifier().getDisplayName() == b.getId().getComponentIdentifier().getDisplayName() ? 0 : (a.getId().getComponentIdentifier().getDisplayName() == null ? -1 : (b.getId().getComponentIdentifier().getDisplayName() == null ? 1 : a.getId().getComponentIdentifier().getDisplayName().compareTo(b.getId().getComponentIdentifier().getDisplayName()))));
                            }

                            @Generated
                            public Integer call(ResolvedArtifact a, ResolvedArtifact b) {
                                return this.doCall(a, b);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure16.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        usedDeclared = set = DefaultGroovyMethods.plus((Set)usedDeclared, (Collection)DefaultGroovyMethods.intersect(usedAggregatorDependencies, (Iterable)((Set)unusedDeclared.get()), (Comparator)((Comparator)ScriptBytecodeAdapter.asType((Object)((Object)new _closure16((Object)this, this.getThisObject())), Comparator.class))));
                        public final class _closure17
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure17(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public ResolvedArtifact doCall(Object it) {
                                return (ResolvedArtifact)ScriptBytecodeAdapter.castToType((Object)it, ResolvedArtifact.class);
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure17.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        List flatten = DefaultGroovyMethods.collect((Iterable)DefaultGroovyMethods.flatten(usedAggregator.values()), (Closure)new _closure17((Object)this, this.getThisObject()));
                        Set set2 = DefaultGroovyMethods.plus((Set)((Set)unusedDeclared.get()), (Collection)DefaultGroovyMethods.intersect((Set)usedDeclared, (Iterable)flatten));
                        unusedDeclared.set((Object)set2);
                        public final class _closure18
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure18(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public ComponentIdentifier doCall(Object it) {
                                return ((ResolvedArtifact)it).getId().getComponentIdentifier();
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public ComponentIdentifier doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure18.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        Reference usedAggregatorComponentIdentifiers = new Reference((Object)((Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.collect(usedAggregatorDependencies, (Closure)new _closure18((Object)this, this.getThisObject())), Set.class)));
                        public final class _closure19
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference usedAggregatorComponentIdentifiers;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure19(Object _outerInstance, Object _thisObject, Reference usedAggregatorComponentIdentifiers) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.usedAggregatorComponentIdentifiers = reference = usedAggregatorComponentIdentifiers;
                            }

                            public Boolean doCall(Object it) {
                                return ((Set)this.usedAggregatorComponentIdentifiers.get()).contains(((ResolvedArtifact)it).getId().getComponentIdentifier());
                            }

                            @Generated
                            public Object getUsedAggregatorComponentIdentifiers() {
                                return this.usedAggregatorComponentIdentifiers.get();
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Boolean doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure19.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        DefaultGroovyMethods.removeAll((Collection)((Set)unusedDeclared.get()), (Closure)new _closure19((Object)this, this.getThisObject(), usedAggregatorComponentIdentifiers));
                        public final class _closure20
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure20(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Set<ResolvedArtifact> doCall(Object it) {
                                return ((ResolvedDependency)it).getAllModuleArtifacts();
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Set<ResolvedArtifact> doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure20.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        public final class _closure21
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure21(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public ComponentIdentifier doCall(Object it) {
                                return ((ResolvedArtifact)it).getId().getComponentIdentifier();
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public ComponentIdentifier doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure21.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        Reference apiComponentIdentifiers = new Reference((Object)((Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.collect((Iterable)((Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.flatten((List)DefaultGroovyMethods.collect(ProjectDependencyResolverUtils.getFirstLevelDependencies(((ProjectDependencyResolver)this.getThisObject()).api), (Closure)new _closure20((Object)this, this.getThisObject()))), Set.class)), (Closure)new _closure21((Object)this, this.getThisObject())), Set.class)));
                        public final class _closure22
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference apiComponentIdentifiers;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure22(Object _outerInstance, Object _thisObject, Reference apiComponentIdentifiers) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.apiComponentIdentifiers = reference = apiComponentIdentifiers;
                            }

                            public Boolean doCall(Object it) {
                                return ((Set)this.apiComponentIdentifiers.get()).contains(((ResolvedArtifact)it).getId().getComponentIdentifier());
                            }

                            @Generated
                            public Object getApiComponentIdentifiers() {
                                return this.apiComponentIdentifiers.get();
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Boolean doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure22.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        DefaultGroovyMethods.removeAll((Collection)((Set)unusedDeclared.get()), (Closure)new _closure22((Object)this, this.getThisObject(), apiComponentIdentifiers));
                        public final class _closure23
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure23(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Set<ResolvedArtifact> doCall(Object it) {
                                return (Set)ScriptBytecodeAdapter.castToType(((ProjectDependencyResolver)this.getThisObject()).aggregatorsWithDependencies.get(it), Set.class);
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Set<ResolvedArtifact> doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure23.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        Set set3 = DefaultGroovyMethods.minus((Set)((Set)usedUndeclared.get()), (Collection)DefaultGroovyMethods.flatten((List)DefaultGroovyMethods.collect(usedAggregatorDependencies, (Closure)new _closure23((Object)this, this.getThisObject()))));
                        usedUndeclared.set((Object)set3);
                        public final class _closure24
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure24(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public ComponentIdentifier doCall(Object it) {
                                return ((ResolvedArtifact)it).getId().getComponentIdentifier();
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public ComponentIdentifier doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure24.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        Reference usedDeclaredComponentIdentifiers = new Reference((Object)((Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.collect((Iterable)usedDeclared, (Closure)new _closure24((Object)this, this.getThisObject())), Set.class)));
                        public final class _closure25
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference usedDeclaredComponentIdentifiers;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure25(Object _outerInstance, Object _thisObject, Reference usedDeclaredComponentIdentifiers) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.usedDeclaredComponentIdentifiers = reference = usedDeclaredComponentIdentifiers;
                            }

                            public Boolean doCall(Object it) {
                                return !((Set)this.usedDeclaredComponentIdentifiers.get()).contains(((ResolvedArtifact)it).getId().getComponentIdentifier());
                            }

                            @Generated
                            public Object getUsedDeclaredComponentIdentifiers() {
                                return this.usedDeclaredComponentIdentifiers.get();
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Boolean doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure25.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        Set set4 = DefaultGroovyMethods.plus((Set)((Set)usedUndeclared.get()), (Collection)DefaultGroovyMethods.findAll(usedAggregatorDependencies, (Closure)new _closure25((Object)this, this.getThisObject(), usedDeclaredComponentIdentifiers)));
                        usedUndeclared.set((Object)set4);
                        public final class _closure26
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference allowedToUseArtifacts;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure26(Object _outerInstance, Object _thisObject, Reference allowedToUseArtifacts) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.allowedToUseArtifacts = reference = allowedToUseArtifacts;
                            }

                            public Boolean doCall(Object it) {
                                return ((Set)this.allowedToUseArtifacts.get()).contains(it) && ((ProjectDependencyResolver)this.getThisObject()).aggregatorsWithDependencies.keySet().contains(it);
                            }

                            @Generated
                            public Object getAllowedToUseArtifacts() {
                                return this.allowedToUseArtifacts.get();
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Boolean doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure26.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        DefaultGroovyMethods.removeAll((Collection)((Set)usedUndeclared.get()), (Closure)new _closure26((Object)this, this.getThisObject(), allowedToUseArtifacts));
                    }
                }
                Set<ResolvedArtifact> compileOnlyDependencyArtifacts = ProjectDependencyResolverUtils.resolveArtifacts(((ProjectDependencyResolver)this.getThisObject()).compileOnly);
                ((AnalyzeDependenciesLogger)logger).info("compileOnlyDependencies", compileOnlyDependencyArtifacts);
                public final class _closure27
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure27(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public ModuleVersionIdentifier doCall(Object it) {
                        return ((ResolvedArtifact)it).getModuleVersion().getId();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public ModuleVersionIdentifier doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure27.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Reference compileOnlyDependencyModuleIdentifiers = new Reference((Object)DefaultGroovyMethods.collect(compileOnlyDependencyArtifacts, (Closure)new _closure27((Object)this, this.getThisObject())));
                public final class _closure28
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference compileOnlyDependencyModuleIdentifiers;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure28(Object _outerInstance, Object _thisObject, Reference compileOnlyDependencyModuleIdentifiers) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.compileOnlyDependencyModuleIdentifiers = reference = compileOnlyDependencyModuleIdentifiers;
                    }

                    public Boolean doCall(Object it) {
                        ModuleVersionIdentifier id = ((ResolvedArtifact)it).getModuleVersion().getId();
                        return ((List)this.compileOnlyDependencyModuleIdentifiers.get()).contains(id);
                    }

                    @Generated
                    public Object getCompileOnlyDependencyModuleIdentifiers() {
                        return this.compileOnlyDependencyModuleIdentifiers.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Boolean doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                public final class _closure29
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference usedUndeclared;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure29(Object _outerInstance, Object _thisObject, Reference usedUndeclared) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.usedUndeclared = reference = usedUndeclared;
                    }

                    public Boolean doCall(Object it) {
                        return ((Set)this.usedUndeclared.get()).add(it);
                    }

                    @Generated
                    public Object getUsedUndeclared() {
                        return this.usedUndeclared.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Boolean doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure29.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.findAll((Set)usedDeclared, (Closure)new _closure28((Object)this, this.getThisObject(), compileOnlyDependencyModuleIdentifiers)).forEach((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure29((Object)this, this.getThisObject(), usedUndeclared)), Consumer.class));
                public final class _closure30
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference unusedDeclared;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure30(Object _outerInstance, Object _thisObject, Reference unusedDeclared) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.unusedDeclared = reference = unusedDeclared;
                    }

                    public Boolean doCall(Object it) {
                        return ((Set)this.unusedDeclared.get()).remove(it);
                    }

                    @Generated
                    public Object getUnusedDeclared() {
                        return this.unusedDeclared.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Boolean doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure30.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                compileOnlyDependencyArtifacts.forEach((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure30((Object)this, this.getThisObject(), unusedDeclared)), Consumer.class));
                public final class _closure31
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure31(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public File doCall(Object it) {
                        return ((ResolvedArtifact)it).getFile();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public File doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure31.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                public final class _closure32
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure32(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public File doCall(Object it) {
                        return ((ResolvedArtifact)it).getFile();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public File doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure32.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                public final class _closure33
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure33(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public File doCall(Object it) {
                        return ((ResolvedArtifact)it).getFile();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public File doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure33.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                public final class _closure34
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure34(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public File doCall(Object it) {
                        return ((ResolvedArtifact)it).getFile();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public File doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure34.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return new ProjectDependencyAnalysisResult((Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.unique((Collection)usedDeclared, (Closure)new _closure31((Object)this, this.getThisObject())), Set.class), (Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.unique((Collection)((Set)usedUndeclared.get()), (Closure)new _closure32((Object)this, this.getThisObject())), Set.class), (Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.unique((Collection)((Set)unusedDeclared.get()), (Closure)new _closure33((Object)this, this.getThisObject())), Set.class), (Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.unique(compileOnlyDependencyArtifacts, (Closure)new _closure34((Object)this, this.getThisObject())), Set.class));
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _analyzeDependencies_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return AnalyzeDependenciesLogger.create(this.logger, this.logFilePath, new _analyzeDependencies_closure1(this, this));
    }

    private List<ResolvedDependency> getRequiredDependencies() {
        return ProjectDependencyResolverUtils.getFirstLevelDependencies(this.require);
    }

    private List<ResolvedDependency> getAllowedToUseDependencies() {
        return ProjectDependencyResolverUtils.getFirstLevelDependencies(this.allowedToUse);
    }

    private List<ResolvedDependency> getAllowedToDeclareDependencies() {
        return ProjectDependencyResolverUtils.getFirstLevelDependencies(this.allowedToDeclare);
    }

    private Map<File, Set<String>> buildArtifactClassMap(List<File> dependencyArtifacts) throws IOException {
        Reference artifactClassMap = new Reference(new LinkedHashMap());
        Reference hits = new Reference((Object)0);
        Reference misses = new Reference((Object)0);
        public final class _buildArtifactClassMap_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference misses;
            private /* synthetic */ Reference hits;
            private /* synthetic */ Reference artifactClassMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildArtifactClassMap_closure2(Object _outerInstance, Object _thisObject, Reference misses, Reference hits, Reference artifactClassMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.misses = reference3 = misses;
                this.hits = reference2 = hits;
                this.artifactClassMap = reference = artifactClassMap;
            }

            public Set<String> doCall(File file) {
                Set classes = (Set)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(((ProjectDependencyResolver)this.getThisObject()).artifactClassCache, (Object)file), Set.class);
                if (classes == null) {
                    Set set;
                    ((ProjectDependencyResolver)this.getThisObject()).logger.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file}, new String[]{"Artifact class cache miss for ", ""})));
                    Object object = this.misses.get();
                    this.misses.set((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.next((Number)((Number)ScriptBytecodeAdapter.castToType((Object)this.misses.get(), Number.class))), Integer.class)));
                    classes = set = DefaultGroovyMethods.asImmutable(ClassFileCollectorUtil.collectFromFile(file));
                    ((ProjectDependencyResolver)this.getThisObject()).artifactClassCache.putIfAbsent(file, classes);
                } else {
                    ((ProjectDependencyResolver)this.getThisObject()).logger.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file}, new String[]{"Artifact class cache hit for ", ""})));
                    Object object = this.hits.get();
                    this.hits.set((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.next((Number)((Number)ScriptBytecodeAdapter.castToType((Object)this.hits.get(), Number.class))), Integer.class)));
                }
                return (Set)ScriptBytecodeAdapter.castToType((Object)((LinkedHashMap)this.artifactClassMap.get()).put(file, classes), Set.class);
            }

            @Generated
            public Set<String> call(File file) {
                return this.doCall(file);
            }

            @Generated
            public Integer getMisses() {
                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.misses.get(), Integer.class);
            }

            @Generated
            public Integer getHits() {
                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.hits.get(), Integer.class);
            }

            @Generated
            public Map getArtifactClassMap() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.artifactClassMap.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildArtifactClassMap_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(dependencyArtifacts, (Closure)new _buildArtifactClassMap_closure2(this, this, misses, hits, artifactClassMap));
        this.logger.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(Integer)hits.get(), (Integer)misses.get(), this.artifactClassCache.size()}, new String[]{"Built artifact class map with ", " hits and ", " misses; cache size is ", ""})));
        return (LinkedHashMap)artifactClassMap.get();
    }

    private Set<String> analyzeClassDependencies() {
        public final class _analyzeClassDependencies_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _analyzeClassDependencies_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Set<String> doCall(File it) {
                return ((ProjectDependencyResolver)this.getThisObject()).dependencyAnalyzer.analyze(it.toURI().toURL());
            }

            @Generated
            public Set<String> call(File it) {
                return this.doCall(it);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _analyzeClassDependencies_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.flatten((List)DefaultGroovyMethods.collect(this.classesDirs, (Closure)new _analyzeClassDependencies_closure3(this, this))), Set.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProjectDependencyResolver.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public static String getCACHE_NAME() {
        return CACHE_NAME;
    }
}

