/*
 * Decompiled with CFR 0.152.
 */
package ca.cutterslade.gradle.analyze;

import ca.cutterslade.gradle.analyze.ProjectDependencyAnalysisResult;
import ca.cutterslade.gradle.analyze.ProjectDependencyResolver;
import ca.cutterslade.gradle.analyze.util.ProjectDependencyAnalysisResultHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class AnalyzeDependenciesTask
extends DefaultTask {
    public static final String DEPENDENCY_ANALYZE_DEPENDENCY_DIRECTORY_NAME = "reports/dependency-analyze";
    @Deprecated
    private Boolean justWarn = false;
    private Boolean warnUsedUndeclared = false;
    private Boolean warnUnusedDeclared = false;
    private Boolean warnCompileOnly = false;
    private Boolean logDependencyInformationToFiles = false;
    private List<Configuration> require = new ArrayList<Configuration>();
    private List<Configuration> compileOnly = new ArrayList<Configuration>();
    private List<Configuration> apiHelperConfiguration = new ArrayList<Configuration>();
    private List<Configuration> allowedToUse = new ArrayList<Configuration>();
    private List<Configuration> allowedToDeclare = new ArrayList<Configuration>();
    private List<Configuration> allowedAggregatorsToUse = new ArrayList<Configuration>();
    private FileCollection classesDirs = this.getProject().files(new Object[0]);

    @Optional
    @OutputFile
    public Path getLogFilePath() {
        return this.logDependencyInformationToFiles != false ? this.getProject().getBuildDir().toPath().resolve(DEPENDENCY_ANALYZE_DEPENDENCY_DIRECTORY_NAME).resolve(this.getName() + ".log") : null;
    }

    @TaskAction
    public void action() throws IOException {
        if (this.justWarn.booleanValue()) {
            this.getLogger().warn("justWarn is deprecated in favor of warnUsedUndeclared and warnUnusedDeclared. Forcefully setting warnUsedUndeclared=true and warnUnusedDeclared=true options");
            this.warnUnusedDeclared = true;
            this.warnUsedUndeclared = true;
        }
        this.getLogger().info("Analyzing dependencies of " + this.getClassesDirs() + " for [require: " + this.getRequire() + ", allowedToUse: " + this.getAllowedToUse() + ", allowedToDeclare: " + this.getAllowedToDeclare() + "]");
        ProjectDependencyAnalysisResult analysis = new ProjectDependencyResolver(this.getProject(), this.require, this.compileOnly, this.apiHelperConfiguration, this.allowedToUse, this.allowedToDeclare, (Iterable<File>)this.classesDirs, this.allowedAggregatorsToUse, this.getLogFilePath()).analyzeDependencies();
        ProjectDependencyAnalysisResultHandler.warnAndLogOrFail(analysis, this.warnUsedUndeclared, this.warnUnusedDeclared, this.warnCompileOnly, this.getLogFilePath(), this.getLogger());
    }

    @Input
    @Deprecated
    public Boolean getJustWarn() {
        return this.justWarn;
    }

    @Deprecated
    public void setJustWarn(boolean justWarn) {
        this.justWarn = justWarn;
    }

    @Input
    public Boolean getWarnUsedUndeclared() {
        return this.warnUsedUndeclared;
    }

    public void setWarnUsedUndeclared(boolean warnUsedUndeclared) {
        this.warnUsedUndeclared = warnUsedUndeclared;
    }

    @Input
    public Boolean getWarnUnusedDeclared() {
        return this.warnUnusedDeclared;
    }

    public void setWarnUnusedDeclared(boolean warnUnusedDeclared) {
        this.warnUnusedDeclared = warnUnusedDeclared;
    }

    @Input
    public Boolean getWarnCompileOnly() {
        return this.warnCompileOnly;
    }

    public void setWarnCompileOnly(boolean warnCompileOnly) {
        this.warnCompileOnly = warnCompileOnly;
    }

    @Input
    public Boolean getLogDependencyInformationToFiles() {
        return this.logDependencyInformationToFiles;
    }

    public void setLogDependencyInformationToFiles(boolean logDependencyInformationToFiles) {
        this.logDependencyInformationToFiles = logDependencyInformationToFiles;
    }

    @InputFiles
    @CompileClasspath
    public List<Configuration> getCompileOnly() {
        return this.compileOnly;
    }

    public void setCompileOnly(List<Configuration> compileOnly) {
        this.compileOnly = compileOnly;
    }

    @InputFiles
    @CompileClasspath
    public List<Configuration> getRequire() {
        return this.require;
    }

    public void setRequire(List<Configuration> require) {
        this.require = require;
    }

    @InputFiles
    @CompileClasspath
    public List<Configuration> getApiHelperConfiguration() {
        return this.apiHelperConfiguration;
    }

    public void setApiHelperConfiguration(List<Configuration> apiHelperConfiguration) {
        this.apiHelperConfiguration = apiHelperConfiguration;
    }

    @InputFiles
    @CompileClasspath
    public List<Configuration> getAllowedToUse() {
        return this.allowedToUse;
    }

    public void setAllowedToUse(List<Configuration> allowedToUse) {
        this.allowedToUse = allowedToUse;
    }

    @InputFiles
    @CompileClasspath
    public List<Configuration> getAllowedToDeclare() {
        return this.allowedToDeclare;
    }

    public void setAllowedToDeclare(List<Configuration> allowedToDeclare) {
        this.allowedToDeclare = allowedToDeclare;
    }

    @InputFiles
    @CompileClasspath
    public List<Configuration> getAllowedAggregatorsToUse() {
        return this.allowedAggregatorsToUse;
    }

    public void setAllowedAggregatorsToUse(List<Configuration> allowedAggregatorsToUse) {
        this.allowedAggregatorsToUse = allowedAggregatorsToUse;
    }

    @InputFiles
    @Classpath
    public FileCollection getClassesDirs() {
        return this.classesDirs;
    }

    public void setClassesDirs(FileCollection classesDirs) {
        this.classesDirs = classesDirs;
    }

    public void setClassesDir(File classesDir) {
        this.classesDirs = this.getProject().files(new Object[]{classesDir});
    }
}

