/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ProgramArguments {
    private static final String JAVACC_PROGRAM_ARGUMENT_FORMAT = "-%1$s=%2$s";
    private final List<String> programArguments = new ArrayList<String>();
    private boolean filenameAdded;

    public void addAll(Map<String, String> arguments) {
        if (arguments != null) {
            for (Map.Entry<String, String> entry : arguments.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
    }

    public void add(String name, String value) {
        String argument = value;
        if (!StringUtils.isEmpty((CharSequence)name)) {
            argument = String.format(JAVACC_PROGRAM_ARGUMENT_FORMAT, name, value);
        }
        if (!this.filenameAdded) {
            this.programArguments.add(argument);
        } else {
            this.programArguments.add(this.programArguments.size() - 1, argument);
        }
    }

    public int size() {
        return this.programArguments.size();
    }

    public String get(int index) {
        return this.programArguments.get(index);
    }

    public String[] toArray() {
        return this.programArguments.toArray(new String[0]);
    }

    public boolean isEmpty() {
        return this.programArguments.isEmpty();
    }

    public void addFilename(String filename) {
        if (this.filenameAdded) {
            this.programArguments.remove(this.programArguments.size() - 1);
            this.filenameAdded = false;
        }
        this.add(null, filename);
        this.filenameAdded = true;
    }

    public String getFilename() {
        return this.programArguments.get(this.programArguments.size() - 1);
    }
}

