/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import ca.coglinc.gradle.plugins.javacc.AbstractJavaccTask;
import ca.coglinc.gradle.plugins.javacc.JavaccSourceFileVisitor;
import ca.coglinc.gradle.plugins.javacc.ProgramArguments;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;

public class CompileJjTreeTask
extends AbstractJavaccTask {
    public static final String TASK_NAME_VALUE = "compileJjtree";
    public static final String TASK_DESCRIPTION_VALUE = "Compiles JJTree files into JavaCC files";
    private static final String DEFAULT_INPUT_DIRECTORY = File.separator + "src" + File.separator + "main" + File.separator + "jjtree";
    private static final String DEFAULT_OUTPUT_DIRECTORY = File.separator + "generated" + File.separator + "jjtree";
    private static final String SUPPORTED_FILE_SUFFIX = ".jjt";

    public CompileJjTreeTask() {
        super(DEFAULT_INPUT_DIRECTORY, DEFAULT_OUTPUT_DIRECTORY, "**/*.jjt");
    }

    @TaskAction
    public void run() {
        this.getTempOutputDirectory().mkdirs();
        this.compileSourceFilesToTempOutputDirectory();
        this.copyCompiledFilesFromTempOutputDirectoryToOutputDirectory();
        this.copyNonJavaccFilesToOutputDirectory();
        FileUtils.deleteQuietly((File)this.getTempOutputDirectory());
    }

    @Override
    protected void augmentArguments(File inputDirectory, RelativePath inputRelativePath, ProgramArguments arguments) {
        arguments.add("JJTREE_OUTPUT_DIRECTORY", inputRelativePath.getFile(this.getTempOutputDirectory()).getParentFile().getAbsolutePath());
    }

    @Override
    protected String getProgramName() {
        return "JJTree";
    }

    @Override
    protected void invokeCompiler(final ProgramArguments arguments) throws Exception {
        ExecResult execResult = this.getProject().javaexec((Action)new Action<JavaExecSpec>(){

            public void execute(JavaExecSpec executor) {
                executor.classpath(new Object[]{CompileJjTreeTask.this.getClasspath()});
                executor.setMain("org.javacc.jjtree.Main");
                executor.args((Object[])arguments.toArray());
                executor.setIgnoreExitValue(true);
            }
        });
        if (execResult.getExitValue() != 0) {
            throw new IllegalStateException("JJTree failed with error code: [" + execResult.getExitValue() + "]");
        }
    }

    @Override
    protected FileVisitor getJavaccSourceFileVisitor() {
        return new JavaccSourceFileVisitor(this);
    }

    @Override
    protected String supportedSuffix() {
        return SUPPORTED_FILE_SUFFIX;
    }
}

