/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc.compilationresults;

import ca.coglinc.gradle.plugins.javacc.compilationresults.CompiledJavaccFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;

public class CompiledJavaccFilesDirectory {
    private File outputDirectory;
    private FileTree customAstClassesDirectory;
    private File targetDirectory;
    private Logger logger;

    CompiledJavaccFilesDirectory(File outputDirectory, FileTree customAstClassesDirectory, File targetDirectory, Logger logger) {
        this.outputDirectory = outputDirectory;
        this.customAstClassesDirectory = customAstClassesDirectory;
        this.targetDirectory = targetDirectory;
        this.logger = logger;
    }

    public Collection<CompiledJavaccFile> listFiles() {
        Collection files = FileUtils.listFiles((File)this.outputDirectory, (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".java"), (IOFileFilter)TrueFileFilter.TRUE);
        ArrayList<CompiledJavaccFile> compiledJavaccFiles = new ArrayList<CompiledJavaccFile>();
        for (File file : files) {
            CompiledJavaccFile compiledJavaccFile = new CompiledJavaccFile(file, this.outputDirectory, this.customAstClassesDirectory, this.targetDirectory, this.logger);
            compiledJavaccFiles.add(compiledJavaccFile);
        }
        return compiledJavaccFiles;
    }

    public String toString() {
        return this.outputDirectory.getAbsolutePath();
    }
}

