/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import ca.coglinc.gradle.plugins.javacc.AbstractJavaccTask;
import ca.coglinc.gradle.plugins.javacc.JavaccSourceFileVisitor;
import ca.coglinc.gradle.plugins.javacc.compilationresults.CompiledJavaccFile;
import ca.coglinc.gradle.plugins.javacc.compilationresults.CompiledJavaccFilesDirectory;
import ca.coglinc.gradle.plugins.javacc.compilationresults.CompiledJavaccFilesDirectoryFactory;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.compile.JavaCompile;
import org.javacc.parser.Main;

public class CompileJavaccTask
extends AbstractJavaccTask {
    public static final String TASK_NAME_VALUE = "compileJavacc";
    public static final String TASK_DESCRIPTION_VALUE = "Compiles JavaCC files into Java files";
    private static final String DEFAULT_INPUT_DIRECTORY = File.separator + "src" + File.separator + "main" + File.separator + "javacc";
    private static final String DEFAULT_OUTPUT_DIRECTORY = File.separator + "generated" + File.separator + "javacc";
    private static final String SUPPORTED_FILE_SUFFIX = ".jj";
    private CompiledJavaccFilesDirectoryFactory compiledJavaccFilesDirectoryFactory = new CompiledJavaccFilesDirectoryFactory();

    public CompileJavaccTask() {
        super(DEFAULT_INPUT_DIRECTORY, DEFAULT_OUTPUT_DIRECTORY, "**/*.jj");
    }

    @TaskAction
    public void run() {
        this.getTempOutputDirectory().mkdirs();
        this.compileSourceFilesToTempOutputDirectory();
        this.copyCompiledFilesFromTempOutputDirectoryToOutputDirectory();
        this.copyNonJavaccFilesToOutputDirectory();
        FileUtils.deleteQuietly((File)this.getTempOutputDirectory());
    }

    private void copyNonJavaccFilesToOutputDirectory() {
        this.getSource().visit(this.getNonJavaccSourceFileVisitor());
    }

    private File getTempOutputDirectory() {
        return new File(this.getOutputDirectory(), "tmp");
    }

    private void compileSourceFilesToTempOutputDirectory() {
        this.getSource().visit(this.getJavaccSourceFileVisitor());
    }

    private void copyCompiledFilesFromTempOutputDirectoryToOutputDirectory() {
        CompiledJavaccFilesDirectory compiledJavaccFilesDirectory = this.compiledJavaccFilesDirectoryFactory.getCompiledJavaccFilesDirectory(this.getTempOutputDirectory(), this.getSourceTree(), this.getOutputDirectory(), this.getLogger());
        for (CompiledJavaccFile compiledJavaccFile : compiledJavaccFilesDirectory.listFiles()) {
            if (compiledJavaccFile.customAstClassExists()) {
                compiledJavaccFile.copyCustomAstClassToTargetDirectory();
                continue;
            }
            compiledJavaccFile.copyCompiledFileToTargetDirectory();
        }
    }

    private FileTree getSourceTree() {
        FileTree sourceTree = this.getSource();
        TaskCollection javaCompileTasks = this.getProject().getTasks().withType(JavaCompile.class);
        for (JavaCompile task : javaCompileTasks) {
            sourceTree = sourceTree.plus(task.getSource());
        }
        Spec<File> outputDirectoryFilter = new Spec<File>(){

            public boolean isSatisfiedBy(File file) {
                return file.getAbsolutePath().contains(CompileJavaccTask.this.getOutputDirectory().getAbsolutePath());
            }
        };
        sourceTree = sourceTree.minus(sourceTree.filter((Spec)outputDirectoryFilter)).getAsFileTree();
        return sourceTree;
    }

    @Override
    protected void augmentArguments(File inputDirectory, RelativePath inputRelativePath, Map<String, String> arguments) {
        arguments.put("OUTPUT_DIRECTORY", inputRelativePath.getFile(this.getTempOutputDirectory()).getParentFile().getAbsolutePath());
    }

    @Override
    protected String getProgramName() {
        return "JavaCC";
    }

    @Override
    protected void invokeCompiler(String[] arguments) throws Exception {
        int errorCode = Main.mainProgram((String[])arguments);
        if (errorCode != 0) {
            throw new IllegalStateException("Javacc failed with error code: [" + errorCode + "]");
        }
    }

    @Override
    protected FileVisitor getJavaccSourceFileVisitor() {
        return new JavaccSourceFileVisitor(this);
    }

    @Override
    protected String supportedSuffix() {
        return SUPPORTED_FILE_SUFFIX;
    }
}

