/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import ca.coglinc.gradle.plugins.javacc.CompileJavaccTask;
import ca.coglinc.gradle.plugins.javacc.CompileJjTreeTask;
import ca.coglinc.gradle.plugins.javacc.JavaToJavaccDependencyAction;
import java.util.HashMap;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class JavaccPlugin
implements Plugin<Project> {
    public static final String GROUP = "JavaCC";

    public void apply(Project project) {
        this.addCompileJavaccTaskToProject(project);
        this.addCompileJJTreeTaskToProject(project);
        JavaToJavaccDependencyAction compileJavaDependsOnCompileJavacc = new JavaToJavaccDependencyAction();
        project.afterEvaluate((Action)compileJavaDependsOnCompileJavacc);
    }

    private void addCompileJavaccTaskToProject(Project project) {
        this.addTaskToProject(project, CompileJavaccTask.class, "compileJavacc", "Compiles JavaCC files into Java files", GROUP);
    }

    private void addCompileJJTreeTaskToProject(Project project) {
        this.addTaskToProject(project, CompileJjTreeTask.class, "compileJjtree", "Compiles JJTree files into JavaCC files", GROUP);
    }

    private void addTaskToProject(Project project, Class<?> type, String name, String description, String group) {
        HashMap<String, Object> options = new HashMap<String, Object>(2);
        options.put("type", type);
        options.put("description", description);
        options.put("group", group);
        project.task(options, name);
    }
}

