/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import ca.coglinc.gradle.plugins.javacc.JavaccTaskException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;

public abstract class AbstractJavaccTask
extends SourceTask {
    private File inputDirectory;
    private File outputDirectory;
    private Map<String, String> programArguments;

    protected AbstractJavaccTask(String inputDirectory, String outputDirectory, String filter) {
        this.setInputDirectory(inputDirectory);
        this.setOutputDirectory(outputDirectory);
        this.include(new String[]{filter});
    }

    @TaskAction
    public void run() {
        this.getOutputDirectory().mkdirs();
        this.getSource().visit((FileVisitor)new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileVisitDetails) {
                AbstractJavaccTask.this.compile(AbstractJavaccTask.this.computeInputDirectory(fileVisitDetails), fileVisitDetails.getRelativePath());
            }
        });
    }

    protected void compile(File inputDirectory, RelativePath inputRelativePath) {
        this.getLogger().debug("Compiling {} file [{}] from [{}] into [{}]", new Object[]{this.getProgramName(), inputRelativePath, inputDirectory, this.getOutputDirectory()});
        String[] arguments = this.buildProgramArguments(inputDirectory, inputRelativePath);
        this.getLogger().debug("Invoking {} with arguments [{}]", (Object)this.getProgramName(), (Object)arguments);
        try {
            this.invokeCompiler(arguments);
        }
        catch (Exception exception) {
            String errorMessage = String.format("Unable to compile '%s' from '%s' into '%s'", inputRelativePath, inputDirectory, this.getOutputDirectory());
            throw new JavaccTaskException(errorMessage, exception);
        }
    }

    protected abstract void invokeCompiler(String[] var1) throws Exception;

    public Map<String, String> getArguments() {
        return this.programArguments;
    }

    public AbstractJavaccTask setArguments(Map<String, String> arguments) {
        this.programArguments = arguments;
        return this;
    }

    public File getInputDirectory() {
        return this.inputDirectory;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public AbstractJavaccTask setInputDirectory(String inputDirectory) {
        return this.setInputDirectory(new File(this.getProject().getProjectDir(), inputDirectory));
    }

    public AbstractJavaccTask setInputDirectory(File inputDirectory) {
        this.getLogger().debug("Changing input directory to [{}]", (Object)inputDirectory);
        this.inputDirectory = inputDirectory;
        this.setSource(inputDirectory);
        return this;
    }

    public AbstractJavaccTask setOutputDirectory(String outputDirectory) {
        return this.setOutputDirectory(new File(this.getProject().getBuildDir(), outputDirectory));
    }

    public AbstractJavaccTask setOutputDirectory(File outputDirectory) {
        this.getLogger().debug("Changing output directory to [{}]", (Object)outputDirectory);
        this.outputDirectory = outputDirectory;
        return this;
    }

    String[] buildProgramArguments(File inputDirectory, RelativePath inputRelativePath) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        if (this.programArguments != null) {
            arguments.putAll(this.programArguments);
        }
        this.augmentArguments(inputDirectory, inputRelativePath, arguments);
        int index = 0;
        String[] commandLineArguments = new String[arguments.size() + 1];
        for (Map.Entry entry : arguments.entrySet()) {
            commandLineArguments[index++] = String.format("-%1$s=%2$s", entry.getKey(), entry.getValue());
        }
        commandLineArguments[commandLineArguments.length - 1] = inputRelativePath.getFile(inputDirectory).getAbsolutePath();
        return commandLineArguments;
    }

    protected abstract void augmentArguments(File var1, RelativePath var2, Map<String, String> var3);

    protected abstract String getProgramName();

    private File computeInputDirectory(FileVisitDetails fileVisitDetails) {
        File fileAbsolute = fileVisitDetails.getFile();
        File fileRelative = new File(fileVisitDetails.getPath());
        return new File(fileAbsolute.getAbsolutePath().replace(fileRelative.getPath(), ""));
    }
}

