/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.javacc.parser.Main;

public class CompileJavaccTask
extends SourceTask {
    public static final String TASK_NAME_VALUE = "compileJavacc";
    public static final String TASK_DESCRIPTION_VALUE = "Compiles javacc files into java files";
    public static final String JAVACC_GROUP = "JavaCC";
    private static final String DEFAULT_INPUT_DIRECTORY = File.separator + "src" + File.separator + "main" + File.separator + "javacc";
    private static final String DEFAULT_OUTPUT_DIRECTORY = File.separator + "generated" + File.separator + "javacc";
    private File inputDirectory = new File(this.getProject().getProjectDir().getAbsolutePath() + DEFAULT_INPUT_DIRECTORY);
    private File outputDirectory = new File(this.getProject().getBuildDir().getAbsolutePath() + DEFAULT_OUTPUT_DIRECTORY);
    private Map<String, String> javaccArguments;

    public CompileJavaccTask() {
        this.getLogger().debug("Using [{}] as source folder", (Object)this.inputDirectory);
        this.setSource(this.inputDirectory);
        this.include(new String[]{"**/*.jj"});
    }

    @TaskAction
    public void executeTask() throws Exception {
        this.outputDirectory.mkdirs();
        Set inputFiles = this.getSource().getFiles();
        this.forEachInputFileCompile(inputFiles);
    }

    private void forEachInputFileCompile(Set<File> inputFiles) throws Exception {
        for (File javaccFile : inputFiles) {
            this.compileToJava(javaccFile);
        }
    }

    private void compileToJava(File javaccFile) throws Exception {
        this.getLogger().debug("Compiling JavaCC file [{}] to [{}]", (Object)javaccFile.getAbsolutePath(), (Object)this.outputDirectory.getAbsolutePath());
        String[] arguments = this.getJavaccArgumentsForCommandLine(javaccFile);
        this.getLogger().debug("Invoking JavaCC with arguments [{}]", (Object[])arguments);
        int errorCode = Main.mainProgram((String[])arguments);
        if (errorCode != 0) {
            throw new IllegalStateException("Javacc failed with error code: [" + errorCode + "]");
        }
    }

    String[] getJavaccArgumentsForCommandLine(File javaccFile) {
        String[] argumentsForCommandLine;
        if (this.javaccArguments != null && !this.javaccArguments.isEmpty()) {
            argumentsForCommandLine = new String[this.javaccArguments.size() + 2];
            int index = 1;
            for (Map.Entry<String, String> argumentEntry : this.javaccArguments.entrySet()) {
                argumentsForCommandLine[index] = String.format("-%1$s=%2$s", argumentEntry.getKey(), argumentEntry.getValue());
                ++index;
            }
        } else {
            argumentsForCommandLine = new String[2];
        }
        argumentsForCommandLine[0] = this.getJavaccOutputDirectoryOption(javaccFile.getParentFile());
        argumentsForCommandLine[argumentsForCommandLine.length - 1] = javaccFile.getAbsolutePath();
        return argumentsForCommandLine;
    }

    private String getJavaccOutputDirectoryOption(File parentFile) {
        return "-OUTPUT_DIRECTORY=" + this.outputDirectory.getAbsolutePath() + parentFile.getAbsolutePath().replace(this.inputDirectory.getAbsolutePath(), "");
    }

    public void setInputDirectory(File inputDirectory) {
        this.getLogger().debug("Changing source folder to [{}]", (Object)inputDirectory);
        this.inputDirectory = inputDirectory;
        this.setSource(inputDirectory);
        this.include(new String[]{"**/*.jj"});
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getInputDirectory() {
        return this.inputDirectory;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public Map<String, String> getJavaccArguments() {
        return this.javaccArguments;
    }

    public void setJavaccArguments(Map<String, String> javaccArguments) {
        this.javaccArguments = javaccArguments;
    }
}

