/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.javacc.parser.Main;

public class CompileJavaccTask
extends DefaultTask {
    public static final String TASK_NAME_VALUE = "compileJavacc";
    public static final String TASK_DESCRIPTION_VALUE = "Compiles javacc files into java files";
    public static final String JAVACC_GROUP = "JavaCC";
    private static final String DEFAULT_INPUT_DIRECTORY = File.separator + "src" + File.separator + "main" + File.separator + "javacc";
    private static final String DEFAULT_OUTPUT_DIRECTORY = File.separator + "generated" + File.separator + "javacc";
    private File inputDirectory = new File(this.getProject().getRootDir().getAbsolutePath() + DEFAULT_INPUT_DIRECTORY);
    private File outputDirectory = new File(this.getProject().getBuildDir().getAbsolutePath() + DEFAULT_OUTPUT_DIRECTORY);

    @TaskAction
    public void executeTask() throws Exception {
        this.outputDirectory.mkdirs();
        File[] inputFiles = this.inputDirectory.listFiles();
        this.compileInputFilesToJava(inputFiles);
    }

    private void compileInputFilesToJava(File[] inputFiles) throws Exception {
        if (this.hasInputFiles(inputFiles)) {
            this.forEachInputFileCompile(inputFiles);
        }
    }

    private boolean hasInputFiles(File[] inputFiles) {
        return inputFiles != null && inputFiles.length > 0;
    }

    private void forEachInputFileCompile(File[] inputFiles) throws Exception {
        for (File javaccFile : inputFiles) {
            this.compileToJava(javaccFile);
        }
    }

    private void compileToJava(File javaccFile) throws Exception {
        if (javaccFile.isDirectory()) {
            this.compileInputFilesToJava(javaccFile.listFiles());
        } else {
            int errorCode = Main.mainProgram((String[])new String[]{this.getJavaccOutputDirectoryOption(javaccFile.getParentFile()), javaccFile.getAbsolutePath()});
            if (errorCode != 0) {
                throw new IllegalStateException("Javacc failed with error code: [" + errorCode + "]");
            }
        }
    }

    private String getJavaccOutputDirectoryOption(File parentFile) {
        return "-OUTPUT_DIRECTORY=" + this.outputDirectory.getAbsolutePath() + parentFile.getAbsolutePath().replace(this.inputDirectory.getAbsolutePath(), "");
    }

    void setInputDirectory(File inputDirectory) {
        this.inputDirectory = inputDirectory;
    }

    void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @InputDirectory
    public File getInputDirectory() {
        return this.inputDirectory;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }
}

