package ca.clinia.vision.helper.searchautocomplete

import ca.clinia.vision.core.connection.ConnectionImpl
import ca.clinia.vision.core.searchautocomplete.SearchAutoCompleteViewModel
import ca.clinia.vision.core.searcher.*

public data class SearchAutoCompleteConnector<R, RQS>(
    public val searcher: Searcher<R>,
    public val searcherQuerySuggestions: SearcherQuerySuggestions<RQS>,
    public val viewModel: SearchAutoCompleteViewModel = SearchAutoCompleteViewModel(),
    public val debouncer: Debouncer = Debouncer(debounceSearchInMillis)
) : ConnectionImpl() {

    private val connectionSearcher = viewModel.connectSearcher(searcher, searcherQuerySuggestions, debouncer)

    override fun connect() {
        super.connect()
        connectionSearcher.connect()
    }

    override fun disconnect() {
        super.disconnect()
        connectionSearcher.disconnect()
    }
}