package ca.clinia.vision.core.searchautocomplete

import ca.clinia.vision.core.connection.ConnectionImpl

internal data class SearchAutoCompleteConnectionView(
    private val viewModel: SearchAutoCompleteViewModel,
    private val view: SearchAutoCompleteView
) : ConnectionImpl() {

    override fun connect() {
        super.connect()
        view.setText(viewModel.query.value)
        view.onQueryChanged = (viewModel.query::value::set)
        view.onQuerySubmitted = {
            viewModel.query.value = it
            viewModel.eventSubmit.send(it)
        }
    }

    override fun disconnect() {
        super.disconnect()
        view.onQueryChanged = null
        view.onQuerySubmitted = null
    }
}