package ca.clinia.vision.helper.searchautocomplete

import ca.clinia.vision.core.connection.Connection
import ca.clinia.vision.core.searchautocomplete.SearchAutoCompleteView
import ca.clinia.vision.core.searchautocomplete.SearchAutoCompleteViewModel
import ca.clinia.vision.core.searchautocomplete.connectView
import ca.clinia.vision.core.searcher.*

public fun <R, RQS> SearchAutoCompleteViewModel.connectSearcher(
    searcher: Searcher<R>,
    searcherQuerySuggestions: SearcherQuerySuggestions<RQS>,
    debouncer: Debouncer = Debouncer(debouncePlacesInMillis)
) : Connection {
    return SearchAutoCompleteConnectionSearcher(this, searcher, searcherQuerySuggestions, debouncer)
}

public fun <R, RQS> SearchAutoCompleteConnector<R, RQS>.connectView(
    view: SearchAutoCompleteView
): Connection {
    return viewModel.connectView(view)
}