package ca.clinia.vision.helper.android.searchautocomplete

import androidx.appcompat.widget.SearchView
import ca.clinia.vision.core.Callback
import ca.clinia.vision.core.searchautocomplete.SearchAutoCompleteView

public class SearchAutoCompleteViewAppCompat(
    public val searchView: SearchView
) : SearchAutoCompleteView {

    override var onQueryChanged: Callback<String?>? = null
    override var onQuerySubmitted: Callback<String?>? = null

    init {
        searchView.setOnQueryTextListener(object : SearchView.OnQueryTextListener {

            override fun onQueryTextSubmit(query: String?): Boolean {
                onQuerySubmitted?.invoke(query)
                return false
            }

            override fun onQueryTextChange(query: String?): Boolean {
                onQueryChanged?.invoke(query)
                return false
            }
        })
    }

    override fun setText(text: String?) {
        searchView.setQuery(text, false)
    }
}