package ca.clinia.vision.helper.android.searchautocomplete

import androidx.lifecycle.LiveData
import androidx.paging.PagedList
import ca.clinia.vision.core.connection.Connection
import ca.clinia.vision.core.searchautocomplete.SearchAutoCompleteView
import ca.clinia.vision.core.searchautocomplete.SearchAutoCompleteViewModel
import ca.clinia.vision.core.searchautocomplete.connectView
import ca.clinia.vision.core.searcher.Debouncer
import ca.clinia.vision.core.searcher.Searcher
import ca.clinia.vision.core.searcher.SearcherQuerySuggestions
import ca.clinia.vision.core.searcher.debounceSearchInMillis

public fun <R, RQS> SearchAutoCompleteViewModel.connectSearcher(
    searcher: Searcher<R>,
    searcherQuerySuggestions: SearcherQuerySuggestions<RQS>,
    pagedList: List<LiveData<out PagedList<out Any>>>,
    debouncer: Debouncer = Debouncer(debounceSearchInMillis)
): Connection {
    return SearchAutoCompleteConnectionSearcherPagedList(this, searcher, searcherQuerySuggestions, pagedList, debouncer)
}

public fun <R, RQS> SearchAutoCompleteConnectorPagedList<R, RQS>.connectView(
    view: SearchAutoCompleteView
): Connection {
    return viewModel.connectView(view)
}