/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.javascript;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LibraryConfiguration {
    private static Pattern patternComment = Pattern.compile("#.*?");
    private static Pattern patternSection = Pattern.compile("\\[(.*)\\]");
    private File sourceDirectory = null;
    private List<String> inputFilePaths = null;
    private File licenseFile = null;
    private CompileLevel compileLevel = CompileLevel.JSMIN;

    public static CompileLevel getCompilerLevelFromName(String name) throws Exception {
        for (CompileLevel level : CompileLevel.values()) {
            if (!level.getName().equals(name)) continue;
            return level;
        }
        throw new Exception("Unknown compiler level: " + name);
    }

    public LibraryConfiguration() {
        this.inputFilePaths = new Vector<String>();
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public List<File> getInputFiles() {
        ArrayList<File> files = new ArrayList<File>(this.inputFilePaths.size());
        for (String filePath : this.inputFilePaths) {
            if (null != this.sourceDirectory) {
                files.add(new File(this.sourceDirectory, filePath));
                continue;
            }
            files.add(new File(filePath));
        }
        return files;
    }

    public List<String> getInputFilePaths() {
        return this.inputFilePaths;
    }

    public void addInputFilePath(String path) {
        this.inputFilePaths.add(path);
    }

    public File getLicenseFile() {
        return this.licenseFile;
    }

    public void setLicenseFile(File licenseFile) {
        this.licenseFile = licenseFile;
    }

    public CompileLevel getCompileLevel() {
        return this.compileLevel;
    }

    public void setCompileLevel(CompileLevel compileLevel) {
        this.compileLevel = compileLevel;
    }

    public void parseConfiguration(Reader reader) throws Exception {
        BufferedReader bufReader = new BufferedReader(reader);
        try {
            boolean isInsideInputSection = false;
            String line = bufReader.readLine();
            while (line != null) {
                Matcher matcherComment = patternComment.matcher(line);
                if (matcherComment.find()) {
                    int index = matcherComment.start();
                    line = line.substring(0, index);
                }
                line = line.trim();
                boolean isSectionLine = false;
                String sectionName = null;
                Matcher matcherSection = patternSection.matcher(line);
                if (matcherSection.matches()) {
                    isSectionLine = true;
                    sectionName = matcherSection.group(1).trim();
                }
                if (!"".equals(line)) {
                    if (isSectionLine) {
                        isInsideInputSection = false;
                        if ("input".equals(sectionName)) {
                            isInsideInputSection = true;
                        }
                    } else if (isInsideInputSection) {
                        this.addInputFilePath(line);
                    }
                }
                line = bufReader.readLine();
            }
        }
        catch (Exception e) {
            throw new Exception("Error while reading compress configuration", e);
        }
    }

    public void parseConfiguration(File configFile) throws Exception {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            fis = new FileInputStream(configFile);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            this.parseConfiguration(isr);
        }
        catch (Exception e) {
            throw new Exception("Error while reading library configuration from file: " + configFile.getAbsolutePath(), e);
        }
        finally {
            if (null != isr) {
                try {
                    isr.close();
                }
                catch (Exception exception) {}
            }
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static enum CompileLevel {
        JSMIN("jsmin"),
        CLOSURE("closure");

        private String name;

        private CompileLevel(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

