/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.javascript;

import ca.carleton.gcrc.javascript.JSMin;
import ca.carleton.gcrc.javascript.LibraryConfiguration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.util.Vector;

public class CompressProcess {
    public void generate(LibraryConfiguration config, File outputFile) throws Exception {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            fos = new FileOutputStream(outputFile);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            this.generate(config, osw);
            osw.flush();
        }
        catch (Exception e) {
            throw new Exception("Error while compressing javacript to file: " + outputFile, e);
        }
        finally {
            if (null != osw) {
                try {
                    osw.close();
                }
                catch (Exception exception) {}
            }
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void generate(LibraryConfiguration config, Writer writer) throws Exception {
        Reader reader = null;
        Vector<InputStream> streams = new Vector<InputStream>();
        SequenceInputStream sis = null;
        try {
            File licenseFile = config.getLicenseFile();
            if (null != licenseFile) {
                InputStream fis = null;
                Object isr = null;
                try {
                    fis = new FileInputStream(licenseFile);
                    isr = new InputStreamReader(fis, "UTF-8");
                    int c = ((InputStreamReader)isr).read();
                    while (c >= 0) {
                        writer.write(c);
                        c = ((InputStreamReader)isr).read();
                    }
                }
                catch (Exception e) {
                    throw new Exception("Error while exporting license file", e);
                }
                finally {
                    if (null != isr) {
                        try {
                            ((InputStreamReader)isr).close();
                        }
                        catch (Exception exception) {}
                    }
                    if (null != fis) {
                        try {
                            ((FileInputStream)fis).close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            byte[] eol = new byte[]{10};
            for (File file : config.getInputFiles()) {
                FileInputStream fis = new FileInputStream(file);
                streams.add(fis);
                ByteArrayInputStream bais = new ByteArrayInputStream(eol);
                streams.add(bais);
            }
            sis = new SequenceInputStream(streams.elements());
            reader = new InputStreamReader((InputStream)sis, "UTF-8");
            JSMin jsMin = new JSMin(reader, writer);
            jsMin.jsmin();
        }
        catch (Exception e) {
            throw new Exception("Error while compressing javascript", e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            for (InputStream fis : streams) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            if (null != sis) {
                try {
                    sis.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

