/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.javascript;

import ca.carleton.gcrc.javascript.LibraryConfiguration;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class ClosureCompilerAdaptor {
    public void verifyFiles(LibraryConfiguration config) throws Exception {
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.setLanguage(CompilerOptions.LanguageMode.ECMASCRIPT5_STRICT);
        compilerOptions.setChecksOnly(true);
        List externs = Collections.emptyList();
        Vector<SourceFile> inputs = new Vector<SourceFile>();
        for (File file : config.getInputFiles()) {
            inputs.add(SourceFile.fromFile((File)file));
        }
        Compiler compiler = new Compiler();
        Result result = compiler.compile(externs, inputs, compilerOptions);
        if (null != result.errors && result.errors.length > 0) {
            for (JSError error : result.errors) {
                System.err.println(error.toString());
            }
            throw new Exception("Verification error");
        }
        if (null != result.warnings && result.warnings.length > 0) {
            for (JSError warning : result.warnings) {
                System.err.println(warning.toString());
            }
        }
    }

    public void compress(LibraryConfiguration config, File outputFile) throws Exception {
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.setLanguage(CompilerOptions.LanguageMode.ECMASCRIPT5_STRICT);
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(compilerOptions);
        List externs = Collections.emptyList();
        Vector<SourceFile> inputs = new Vector<SourceFile>();
        for (File file : config.getInputFiles()) {
            inputs.add(SourceFile.fromFile((File)file));
        }
        Compiler compiler = new Compiler();
        Result result = compiler.compile(externs, inputs, compilerOptions);
        if (null != result.errors && result.errors.length > 0) {
            for (JSError error : result.errors) {
                System.err.println(error.toString());
            }
            throw new Exception("Compression error");
        }
        if (result.success) {
            String code = compiler.toSource();
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            try {
                fos = new FileOutputStream(outputFile);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                File licenseFile = config.getLicenseFile();
                if (null != licenseFile) {
                    FileInputStream fis = null;
                    InputStreamReader isr = null;
                    try {
                        fis = new FileInputStream(licenseFile);
                        isr = new InputStreamReader((InputStream)fis, "UTF-8");
                        int c = isr.read();
                        while (c >= 0) {
                            osw.write(c);
                            c = isr.read();
                        }
                        isr.close();
                        isr = null;
                        fis.close();
                        fis = null;
                    }
                    catch (Exception e) {
                        throw new Exception("Error while exporting license file", e);
                    }
                    finally {
                        if (null != isr) {
                            try {
                                isr.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (null != fis) {
                            try {
                                fis.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                osw.write(code);
                osw.flush();
                osw.close();
                osw = null;
                fos.close();
                fos = null;
            }
            catch (Exception e) {
                throw new Exception("Error while writing out code", e);
            }
            finally {
                if (null != osw) {
                    try {
                        osw.close();
                    }
                    catch (Exception exception) {}
                }
                if (null != fos) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

