/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.javascript;

import ca.carleton.gcrc.javascript.JavascriptRunnerListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class JavascriptRunner {
    private Context cx = null;
    private Scriptable scope = null;
    private List<JavascriptRunnerListener> listeners = new Vector<JavascriptRunnerListener>();

    public static Object opt(Object o, String attributeName, Object def) {
        Object result = null;
        if (o instanceof Scriptable) {
            Scriptable s = (Scriptable)o;
            result = s.get(attributeName, s);
        }
        if (null == result) {
            return def;
        }
        return result;
    }

    public static Object opt(Object o, int index, Object def) {
        Object result = null;
        if (o instanceof Scriptable) {
            Scriptable s = (Scriptable)o;
            result = s.get(index, s);
        }
        if (null == result) {
            return def;
        }
        return result;
    }

    public static Object opt(Object o, String attributeName) {
        return JavascriptRunner.opt(o, attributeName, null);
    }

    public static Object opt(Object o, int index) {
        return JavascriptRunner.opt(o, index, null);
    }

    public static String optString(Object o, String attributeName) {
        Object result = JavascriptRunner.opt(o, attributeName);
        if (null == result) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        return null;
    }

    public static String optString(Object o, int index) {
        Object result = JavascriptRunner.opt(o, index);
        if (null == result) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        return null;
    }

    public static String optString(Object o, String attributeName, String defaultValue) {
        String result = JavascriptRunner.optString(o, attributeName);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public static String optString(Object o, int index, String defaultValue) {
        String result = JavascriptRunner.optString(o, index);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public static Integer optInteger(Object o, String attributeName) {
        Object result = JavascriptRunner.opt(o, attributeName);
        if (null == result) {
            return null;
        }
        if (result instanceof Number) {
            Number n = (Number)result;
            return n.intValue();
        }
        return null;
    }

    public static Integer optInteger(Object o, int index) {
        Object result = JavascriptRunner.opt(o, index);
        if (null == result) {
            return null;
        }
        if (result instanceof Number) {
            Number n = (Number)result;
            return n.intValue();
        }
        return null;
    }

    public static int optInteger(Object o, String attributeName, int defaultValue) {
        Integer result = JavascriptRunner.optInteger(o, attributeName);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public static int optInteger(Object o, int index, int defaultValue) {
        Integer result = JavascriptRunner.optInteger(o, index);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public static Long optLong(Object o, String attributeName) {
        Object result = JavascriptRunner.opt(o, attributeName);
        if (null == result) {
            return null;
        }
        if (result instanceof Number) {
            Number n = (Number)result;
            return n.longValue();
        }
        return null;
    }

    public static Long optLong(Object o, int index) {
        Object result = JavascriptRunner.opt(o, index);
        if (null == result) {
            return null;
        }
        if (result instanceof Number) {
            Number n = (Number)result;
            return n.longValue();
        }
        return null;
    }

    public static long optLong(Object o, String attributeName, long defaultValue) {
        Long result = JavascriptRunner.optLong(o, attributeName);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public static long optLong(Object o, int index, long defaultValue) {
        Long result = JavascriptRunner.optLong(o, index);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public static Double optDouble(Object o, String attributeName) {
        Object result = JavascriptRunner.opt(o, attributeName);
        if (null == result) {
            return null;
        }
        if (result instanceof Number) {
            Number n = (Number)result;
            return n.doubleValue();
        }
        return null;
    }

    public static Double optDouble(Object o, int index) {
        Object result = JavascriptRunner.opt(o, index);
        if (null == result) {
            return null;
        }
        if (result instanceof Number) {
            Number n = (Number)result;
            return n.doubleValue();
        }
        return null;
    }

    public static double optDouble(Object o, String attributeName, double defaultValue) {
        Double result = JavascriptRunner.optDouble(o, attributeName);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public static double optDouble(Object o, int index, double defaultValue) {
        Double result = JavascriptRunner.optDouble(o, index);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public static List<?> optArray(Object o, String attributeName) {
        Scriptable s;
        Object obj = JavascriptRunner.opt(o, attributeName);
        if (null == obj) {
            return null;
        }
        if (obj instanceof Scriptable && "Array".equals((s = (Scriptable)obj).getClassName())) {
            int length = JavascriptRunner.optInteger((Object)s, "length", 0);
            Vector<Object> result = new Vector<Object>();
            for (int i = 0; i < length; ++i) {
                Object elem = JavascriptRunner.opt((Object)s, i);
                result.add(elem);
            }
            return result;
        }
        return null;
    }

    public JavascriptRunner() {
        ContextFactory factory = new ContextFactory();
        this.cx = factory.enterContext();
        this.scope = this.cx.initStandardObjects();
    }

    public void cleanup() {
        Context.exit();
        this.cx = null;
        this.scope = null;
    }

    public void addListener(JavascriptRunnerListener listener) {
        this.listeners.add(listener);
    }

    public Object evaluateJavascript(String javascript) throws Exception {
        try {
            Object result = this.cx.evaluateString(this.scope, javascript, "main", 1, null);
            return result;
        }
        catch (EcmaError e) {
            for (JavascriptRunnerListener listener : this.listeners) {
                listener.runtimeError(e.details(), e.sourceName(), e.lineNumber());
            }
            throw e;
        }
    }

    public void addJavascript(File file) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            this.addJavascript(isr, file.getAbsolutePath(), 1);
        }
        catch (FileNotFoundException e) {
            this.reportUnexpectedError(e);
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            this.reportUnexpectedError(e);
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                    fis = null;
                }
                catch (Exception e) {}
            }
        }
    }

    public void addJavascript(Reader reader, String name, int lineno) throws Exception {
        try {
            Script script = this.cx.compileReader(reader, name, lineno, null);
            script.exec(this.cx, this.scope);
        }
        catch (EvaluatorException e) {
            for (JavascriptRunnerListener listener : this.listeners) {
                listener.compileError(e.details(), e.sourceName(), e.lineNumber(), e.columnNumber());
            }
            throw e;
        }
        catch (Exception e) {
            this.reportUnexpectedError(e);
            throw e;
        }
    }

    private void reportUnexpectedError(Exception e) {
        for (JavascriptRunnerListener listener : this.listeners) {
            listener.unexpectedError(e);
        }
    }
}

