/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.javascript;

import ca.carleton.gcrc.javascript.CompressProcess;
import ca.carleton.gcrc.javascript.DebugProcess;
import ca.carleton.gcrc.javascript.LibraryConfiguration;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class JavascriptMain {
    public static void main(String[] args) {
        try {
            ArrayList<String> arguments = new ArrayList<String>(args.length);
            for (String arg : args) {
                arguments.add(arg);
            }
            JavascriptMain app = new JavascriptMain();
            app.execute(arguments);
            System.exit(0);
        }
        catch (Exception e) {
            PrintStream err = System.err;
            e.printStackTrace(err);
            System.exit(1);
        }
    }

    public void execute(List<String> args) throws Exception {
        LibraryConfiguration config = new LibraryConfiguration();
        File outputFile = null;
        File outputDebugFile = null;
        Stack<String> argumentStack = new Stack<String>();
        for (int i = args.size() - 1; i >= 0; --i) {
            argumentStack.push(args.get(i));
        }
        while (!argumentStack.empty()) {
            String outputFileName;
            String optionName = (String)argumentStack.peek();
            if ("--config-file".equals(optionName)) {
                argumentStack.pop();
                if (argumentStack.empty()) {
                    throw new Exception("File expected for option '--config-file'");
                }
                String configFileName = (String)argumentStack.pop();
                File configFile = new File(configFileName);
                System.out.println("--config-file " + configFile.getAbsolutePath());
                config.parseConfiguration(configFile);
                continue;
            }
            if ("--source-dir".equals(optionName)) {
                argumentStack.pop();
                if (argumentStack.empty()) {
                    throw new Exception("Directory expected for option '--source-dir'");
                }
                String sourceDirName = (String)argumentStack.pop();
                File sourceDir = new File(sourceDirName);
                System.out.println("--source-dir " + sourceDir.getAbsolutePath());
                config.setSourceDirectory(sourceDir);
                continue;
            }
            if ("--license-file".equals(optionName)) {
                argumentStack.pop();
                if (argumentStack.empty()) {
                    throw new Exception("File expected for option '--license-file'");
                }
                String licenseFileName = (String)argumentStack.pop();
                File licenseFile = new File(licenseFileName);
                System.out.println("--license-file " + licenseFile.getAbsolutePath());
                config.setLicenseFile(licenseFile);
                continue;
            }
            if ("--output".equals(optionName)) {
                argumentStack.pop();
                if (argumentStack.empty()) {
                    throw new Exception("File expected for option '--output'");
                }
                outputFileName = (String)argumentStack.pop();
                outputFile = new File(outputFileName);
                System.out.println("--ouput " + outputFile.getAbsolutePath());
                continue;
            }
            if ("--output-debug".equals(optionName)) {
                argumentStack.pop();
                if (argumentStack.empty()) {
                    throw new Exception("File expected for option '--output-debug'");
                }
                outputFileName = (String)argumentStack.pop();
                outputDebugFile = new File(outputFileName);
                System.out.println("--ouput-debug " + outputDebugFile.getAbsolutePath());
                continue;
            }
            System.err.println("Unknown option: " + optionName);
            argumentStack.pop();
        }
        if (null != outputFile) {
            System.out.println("Generating release version");
            CompressProcess process = new CompressProcess();
            process.generate(config, outputFile);
        }
        if (null != outputDebugFile) {
            System.out.println("Generating debug version");
            DebugProcess process = new DebugProcess();
            process.generate(config, outputDebugFile);
        }
    }
}

