/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.javascript;

import ca.carleton.gcrc.javascript.LibraryConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class DebugProcess {
    public void generate(LibraryConfiguration config, File outputFile) throws Exception {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            fos = new FileOutputStream(outputFile);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            this.generate(config, outputFile.getName(), osw);
            osw.flush();
        }
        catch (Exception e) {
            throw new Exception("Error while compressing javacript to file: " + outputFile, e);
        }
        finally {
            if (null != osw) {
                try {
                    osw.close();
                }
                catch (Exception e) {}
            }
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void generate(LibraryConfiguration config, String outputName, Writer writer) throws Exception {
        try {
            PrintWriter pw = new PrintWriter(writer);
            File licenseFile = config.getLicenseFile();
            if (null != licenseFile) {
                FileInputStream fis = null;
                InputStreamReader isr = null;
                try {
                    fis = new FileInputStream(licenseFile);
                    isr = new InputStreamReader((InputStream)fis, "UTF-8");
                    int c = isr.read();
                    while (c >= 0) {
                        writer.write(c);
                        c = isr.read();
                    }
                }
                catch (Exception e) {
                    throw new Exception("Error while exporting license file", e);
                }
                finally {
                    if (null != isr) {
                        try {
                            isr.close();
                        }
                        catch (Exception e) {}
                    }
                    if (null != fis) {
                        try {
                            fis.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            pw.println(";(function(){");
            pw.println("var scriptLocation = null;");
            pw.println("var pattern = new RegExp('(^|(.*?\\/))" + outputName + "$');");
            pw.println("var scripts = document.getElementsByTagName('script');");
            pw.println("for( var loop=0; loop<scripts.length; ++loop ) {");
            pw.println("\tvar src = scripts[loop].getAttribute('src');");
            pw.println("\tif (src) {");
            pw.println("\t\tvar match = src.match(pattern);");
            pw.println("\t\tif( match ) {");
            pw.println("\t\t\tscriptLocation = match[1];");
            pw.println("\t\t\tbreak;");
            pw.println("\t\t}");
            pw.println("\t}");
            pw.println("};");
            pw.println("if( null === scriptLocation ) {");
            pw.println("\talert('Unable to find library tag (" + outputName + ")');");
            pw.println("};");
            pw.println("nunaliit2CoreScript = '" + outputName + "';");
            pw.println("var jsfiles = [");
            boolean first = true;
            for (String path : config.getInputFilePaths()) {
                if (first) {
                    first = false;
                } else {
                    pw.print(",");
                }
                pw.println("'" + path + "'");
            }
            pw.println("];");
            pw.println("var allScriptTags = new Array();");
            pw.println("for( var i=0; i<jsfiles.length; ++i ) {");
            pw.println("\tallScriptTags.push('<script src=\"');");
            pw.println("\tallScriptTags.push(scriptLocation);");
            pw.println("\tallScriptTags.push(jsfiles[i]);");
            pw.println("\tallScriptTags.push('\"></script>');");
            pw.println("};");
            pw.println("document.write(allScriptTags.join(''));");
            pw.println("})();");
            pw.flush();
        }
        catch (Exception e) {
            throw new Exception("Error while creating debug version of javascript library", e);
        }
    }
}

