/*
 * Copyright (c)2014 Braun IT Solutions Ltd, Vancouver, Canada
 * http://www.braun-it.ca
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package ca.braunit.weatherparser.util;

/**
 * This utility class is used for storing the constant values
 * used within the WeatherParser.
 * @author Alexander Braun
 */
public final class WeatherParserConstants {

	/**
	 * Unit of measure, Abbreviation for Meter
	 */
	public static final String UNIT_OF_MEASURE_METER = "M";
	
	/**
	 * Unit of measure, Abbreviation for Feet
	 */
	public static final String UNIT_OF_MEASURE_FEET = "FT";
	
	/**
	 * Unit of measure, Abbreviation for Nautical Miles
	 */
	public static final String UNIT_OF_MEASURE_NAUTICAL_MILES = "NM";
	
	/**
	 * Unit of measure, Abbreviation for Statute Miles
	 */
	public static final String UNIT_OF_MEASURE_STATUTE_MILES = "SM";
	
	/**
	 * Unit of measure, Abbreviation for Knots
	 */
	public static final String UNIT_OF_MEASURE_KNOTS = "KT";

	/**
	 * The code for indicating less than
	 */
	public static final String LESS_THAN_CODE = "M";
	
	/**
	 * The code for indicating more than
	 */
	public static final String MORE_THAN_CODE = "P";
	
	/**
	 * The code for indicating negative values
	 */
	public static final String NEGATIVE_VALUE_CODE = "M";
}
