/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.taf.util;

import ca.braunit.weatherparser.exception.DecoderException;
import ca.braunit.weatherparser.metar.util.CommonDecoder;
import ca.braunit.weatherparser.taf.domain.Turbulence;
import java.util.HashMap;
import java.util.Map;

public class TurbulenceDecoder {
    private static final String TURBULENCE_PATTERN = "5[\\d]{5}( |\\Z)(.)*";
    private static final Map<Integer, String> INTENSITY_MAP = new HashMap<Integer, String>();

    public static Turbulence decodeObject(StringBuffer tafAsString) throws DecoderException {
        Turbulence turbulence = null;
        if (tafAsString.toString().matches(TURBULENCE_PATTERN)) {
            turbulence = new Turbulence();
            tafAsString.delete(0, 1);
            turbulence.setTurbulenceIntensityCode(Integer.parseInt(tafAsString.substring(0, 1)));
            turbulence.setTurbulenceIntensity(INTENSITY_MAP.get(turbulence.getTurbulenceIntensityCode()));
            tafAsString.delete(0, 1);
            turbulence.setTurbulenceLayerBase(Integer.parseInt(tafAsString.substring(0, 3)) * 100);
            tafAsString.delete(0, 3);
            turbulence.setTurbulenceLayerDepth(Integer.parseInt(tafAsString.substring(0, 1)) * 1000);
            CommonDecoder.deleteParsedContent(tafAsString);
        }
        return turbulence;
    }

    static {
        INTENSITY_MAP.put(0, "none");
        INTENSITY_MAP.put(1, "light turbulence");
        INTENSITY_MAP.put(2, "moderate turbulence in clean air, occasional");
        INTENSITY_MAP.put(3, "moderate turbulence in clean air, frequent");
        INTENSITY_MAP.put(4, "moderate turbulence in cloud, occasional");
        INTENSITY_MAP.put(5, "moderate turbulence in cloud, frequent");
        INTENSITY_MAP.put(6, "severe turbulence in clean air, occasional");
        INTENSITY_MAP.put(7, "severe turbulence in clean air, frequent");
        INTENSITY_MAP.put(8, "severe turbulence in cloud, occasional");
        INTENSITY_MAP.put(9, "severe turbulence in cloud, frequent");
    }
}

