/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.common.util;

import ca.braunit.weatherparser.common.domain.ValidityPeriod;
import ca.braunit.weatherparser.exception.DecoderException;
import ca.braunit.weatherparser.metar.util.CommonDecoder;

public class ValidityPeriodDecoder {
    private static final String VALIDITY_PERIOD_PATTERN = "(\\d){4}(/)(\\d){4}.*";

    public static ValidityPeriod decodeObject(StringBuffer tafAsString) throws DecoderException {
        ValidityPeriod validityPeriod = new ValidityPeriod();
        if (tafAsString.toString().matches(VALIDITY_PERIOD_PATTERN)) {
            validityPeriod.setFromDayOfMonth(Integer.parseInt(tafAsString.substring(0, 2)));
            validityPeriod.setFromHour(Integer.parseInt(tafAsString.substring(2, 4)));
            validityPeriod.setToDayOfMonth(Integer.parseInt(tafAsString.substring(5, 7)));
            validityPeriod.setToHour(Integer.parseInt(tafAsString.substring(7, 9)));
            CommonDecoder.deleteParsedContent(tafAsString);
        }
        return validityPeriod;
    }
}

