/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.taf.util;

import ca.braunit.weatherparser.common.domain.TimeInfo;
import ca.braunit.weatherparser.metar.util.CommonDecoder;
import ca.braunit.weatherparser.taf.domain.Temperature;
import java.util.ArrayList;
import java.util.List;

public class TemperatureDecoder {
    private static final String MAXIMUM_TEMPERATURE = "X";
    private static final String MINIMUM_TEMPERATURE = "N";
    private static final String TEMPERATURE_PATTERN = "T(N|X)?(M)?(\\d){2}/(\\d){4}(z|Z)( |\\Z)(.)*";

    public static List<Temperature> decodeObject(StringBuffer tafAsString) {
        ArrayList<Temperature> tempList = new ArrayList<Temperature>();
        Temperature temperature = null;
        while (tafAsString.toString().matches(TEMPERATURE_PATTERN)) {
            temperature = new Temperature();
            tafAsString.delete(0, 1);
            int multiplier = 1;
            if (tafAsString.toString().startsWith(MAXIMUM_TEMPERATURE)) {
                temperature.setMaximumTemperature(true);
                tafAsString.delete(0, 1);
            }
            if (tafAsString.toString().startsWith(MINIMUM_TEMPERATURE)) {
                temperature.setMinimumTemperature(true);
                tafAsString.delete(0, 1);
            }
            if (tafAsString.toString().startsWith("M")) {
                multiplier = -1;
                tafAsString.delete(0, 1);
            }
            temperature.setTemperature(Integer.parseInt(tafAsString.substring(0, 2)) * multiplier);
            tafAsString.delete(0, 3);
            TimeInfo time = new TimeInfo();
            time.setDayOfMonth(Integer.parseInt(tafAsString.substring(0, 2)));
            tafAsString.delete(0, 2);
            time.setHour(Integer.parseInt(tafAsString.substring(0, 2)));
            time.setMinute(0);
            temperature.setTime(time);
            CommonDecoder.deleteParsedContent(tafAsString);
            tempList.add(temperature);
        }
        return tempList;
    }
}

