/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.taf.util;

import ca.braunit.weatherparser.common.util.CloudsDecoder;
import ca.braunit.weatherparser.common.util.TimeInfoDecoder;
import ca.braunit.weatherparser.common.util.ValidityPeriodDecoder;
import ca.braunit.weatherparser.common.util.VisibilityDecoder;
import ca.braunit.weatherparser.common.util.WeatherDecoder;
import ca.braunit.weatherparser.common.util.WindDecoder;
import ca.braunit.weatherparser.exception.DecoderException;
import ca.braunit.weatherparser.metar.util.CommonDecoder;
import ca.braunit.weatherparser.taf.TafDecoderResult;
import ca.braunit.weatherparser.taf.domain.ExpectedChange;
import ca.braunit.weatherparser.taf.util.IcingConditionsDecoder;
import ca.braunit.weatherparser.taf.util.MinimumAltimeterSettingDecoder;
import ca.braunit.weatherparser.taf.util.TemperatureDecoder;
import ca.braunit.weatherparser.taf.util.TurbulenceDecoder;
import ca.braunit.weatherparser.taf.util.WindShearDecoder;
import java.util.ArrayList;
import java.util.List;

public class ExpectedChangeDecoder {
    private static final String EXPECTED_CHANGE_PATTERN = "(TEMPO |BECMG |FM[\\d]{6} |PROB[\\d]{2} )(.)*";
    private static final String FROM_PATTERN = "FM[\\d]{6} (.)*";
    private static final String BECOMING_PATTERN = "BECMG (.)*";
    private static final String TEMPORARY_PATTERN = "TEMPO (.)*";
    private static final String PROBABILITY_PATTERN = "PROB[\\d]{2} (.)*";

    public static List<ExpectedChange> decodeObject(StringBuffer tafAsString, TafDecoderResult tdResult) throws DecoderException {
        ArrayList<ExpectedChange> expectedChanges = new ArrayList<ExpectedChange>();
        while (tafAsString.toString().matches(EXPECTED_CHANGE_PATTERN)) {
            ExpectedChange expectedChange = new ExpectedChange();
            ExpectedChangeDecoder.decodeChangeType(tafAsString, expectedChange);
            ExpectedChangeDecoder.decodeValidityPeriodOrFromTime(tafAsString, expectedChange);
            while (tafAsString.length() > 0 && !tafAsString.toString().matches(EXPECTED_CHANGE_PATTERN)) {
                expectedChange.setWind(WindDecoder.decodeObject(tafAsString));
                expectedChange.setVisibility(VisibilityDecoder.decodeObject(tafAsString));
                expectedChange.setForecastWeather(WeatherDecoder.decodeObject(tafAsString));
                if (null == expectedChange.getVisibility()) {
                    expectedChange.setVisibility(VisibilityDecoder.decodeObject(tafAsString));
                }
                expectedChange.setClouds(CloudsDecoder.decodeObject(tafAsString));
                expectedChange.setIcingConditions(IcingConditionsDecoder.decodeObject(tafAsString));
                expectedChange.setTurbulence(TurbulenceDecoder.decodeObject(tafAsString));
                expectedChange.setWindShear(WindShearDecoder.decodeObject(tafAsString));
                expectedChange.setMinimumAltimeterSettings(MinimumAltimeterSettingDecoder.decodeObject(tafAsString));
                expectedChange.setTemperature(TemperatureDecoder.decodeObject(tafAsString));
                if (null == expectedChange.getWindShear()) {
                    expectedChange.setWindShear(WindShearDecoder.decodeObject(tafAsString));
                }
                if (tafAsString.length() <= 0 || tafAsString.toString().matches(EXPECTED_CHANGE_PATTERN)) continue;
                tdResult.addUnparsedToken(CommonDecoder.getContentToParse(tafAsString));
                CommonDecoder.deleteParsedContent(tafAsString);
            }
            expectedChanges.add(expectedChange);
        }
        return expectedChanges;
    }

    private static void decodeChangeType(StringBuffer tafAsString, ExpectedChange expectedChange) {
        if (tafAsString.toString().matches(FROM_PATTERN)) {
            expectedChange.setChangeType(ExpectedChange.ChangeType.FROM);
            expectedChange.setChangeTypeCode("FM");
            tafAsString.delete(0, 2);
        } else if (tafAsString.toString().matches(BECOMING_PATTERN)) {
            expectedChange.setChangeType(ExpectedChange.ChangeType.BECOMING);
            expectedChange.setChangeTypeCode("BECMG");
            CommonDecoder.deleteParsedContent(tafAsString);
        } else if (tafAsString.toString().matches(TEMPORARY_PATTERN)) {
            expectedChange.setChangeType(ExpectedChange.ChangeType.TEMPORARY);
            expectedChange.setChangeTypeCode("TEMPO");
            CommonDecoder.deleteParsedContent(tafAsString);
        } else if (tafAsString.toString().matches(PROBABILITY_PATTERN)) {
            expectedChange.setChangeType(ExpectedChange.ChangeType.PROBABILITY);
            expectedChange.setChangeTypeCode("PROB");
            tafAsString.delete(0, 4);
            ExpectedChangeDecoder.decodeProbability(tafAsString, expectedChange);
            if (tafAsString.toString().matches(EXPECTED_CHANGE_PATTERN)) {
                ExpectedChangeDecoder.decodeChangeType(tafAsString, expectedChange);
            }
        }
    }

    private static void decodeProbability(StringBuffer tafAsString, ExpectedChange expectedChange) {
        expectedChange.setProbabilityOfChange(Integer.parseInt(tafAsString.substring(0, 2)));
        CommonDecoder.deleteParsedContent(tafAsString);
    }

    private static void decodeValidityPeriodOrFromTime(StringBuffer tafAsString, ExpectedChange expectedChange) throws DecoderException {
        if (expectedChange.getChangeType().equals((Object)ExpectedChange.ChangeType.FROM)) {
            expectedChange.setFromTime(TimeInfoDecoder.decodeObject(tafAsString, true));
        } else {
            expectedChange.setValidityPeriod(ValidityPeriodDecoder.decodeObject(tafAsString));
        }
    }
}

