/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.common.util;

import ca.braunit.weatherparser.common.domain.Wind;
import ca.braunit.weatherparser.metar.util.CommonDecoder;

public class WindDecoder {
    private static final String VARIABLE_WIND_DIVIDER = "V";
    private static final int WINDDIRECTION_LENGTH = 3;
    private static final int WINDSPEED_LENGTH = 2;
    private static final String WIND_PATTERN = "[\\d]{5}(KMH|MPS|KT)( |\\Z)(.)*";
    private static final String WIND_WITH_GUSTS_PATTERN = "[\\d]{5}(G)[\\d]{2}(KMH|MPS|KT)( |\\Z)(.)*";
    private static final String VARIABLE_WIND_PATTERN = "[\\d]{3}V[\\d]{3}( |\\Z)(.)*";
    private static final String VARIABLE_LIGHT_WIND_PATTERN = "VRB[\\d]{2}KT( |\\Z)(.)*";
    private static final String VARIABLE_WIND_WITH_GUSTS_PATTERN = "VRB[\\d]{2}((G)[\\d]{2})?KT( |\\Z)(.)*";

    public static Wind decodeObject(StringBuffer metarAsString) {
        Wind wind = new Wind();
        if (metarAsString.toString().matches(WIND_PATTERN)) {
            WindDecoder.decodeWindPattern(metarAsString, wind);
        } else if (metarAsString.toString().matches(WIND_WITH_GUSTS_PATTERN)) {
            WindDecoder.decodeWindWithGustsPattern(metarAsString, wind);
        }
        if (metarAsString.toString().matches(VARIABLE_WIND_PATTERN)) {
            WindDecoder.decodeVariableWindDirection(metarAsString, wind);
        } else if (metarAsString.toString().matches(VARIABLE_LIGHT_WIND_PATTERN)) {
            WindDecoder.decodeLightVariableWind(metarAsString, wind);
        } else if (metarAsString.toString().matches(VARIABLE_WIND_WITH_GUSTS_PATTERN)) {
            WindDecoder.decodeVariableWindWithGusts(metarAsString, wind);
        }
        return wind;
    }

    private static void decodeWindPattern(StringBuffer metarAsString, Wind wind) {
        WindDecoder.decodeWindDirectionAndSpeed(metarAsString, wind);
        WindDecoder.decodeSpeedUnitOfMeasure(metarAsString, wind);
    }

    private static void decodeWindWithGustsPattern(StringBuffer metarAsString, Wind wind) {
        WindDecoder.decodeWindDirectionAndSpeed(metarAsString, wind);
        WindDecoder.decodeWindSpeedGusts(metarAsString, wind);
        WindDecoder.decodeSpeedUnitOfMeasure(metarAsString, wind);
    }

    private static void decodeWindDirectionAndSpeed(StringBuffer metarAsString, Wind wind) {
        wind.setWindDirection(Integer.parseInt(metarAsString.substring(0, 3)));
        metarAsString.delete(0, 3);
        wind.setWindSpeed(Integer.parseInt(metarAsString.substring(0, 2)));
        metarAsString.delete(0, 2);
    }

    private static void decodeSpeedUnitOfMeasure(StringBuffer metarAsString, Wind wind) {
        wind.setSpeedUnitOfMeasure(CommonDecoder.getContentToParse(metarAsString));
        CommonDecoder.deleteParsedContent(metarAsString);
    }

    private static void decodeWindSpeedGusts(StringBuffer metarAsString, Wind wind) {
        metarAsString.delete(0, 1);
        wind.setWindSpeedGusts(Integer.parseInt(metarAsString.substring(0, 2)));
        metarAsString.delete(0, 2);
    }

    private static void decodeVariableWindDirection(StringBuffer metarAsString, Wind wind) {
        if (metarAsString.substring(0, 3 + VARIABLE_WIND_DIVIDER.length() + 3).matches(VARIABLE_WIND_PATTERN)) {
            wind.setVariableWindDirectionFrom(Integer.parseInt(metarAsString.substring(0, 3)));
            metarAsString.delete(0, 4);
            wind.setVariableWindDirectionTo(Integer.parseInt(metarAsString.substring(0, 3)));
            metarAsString.delete(0, 4);
            wind.setVariableWind(true);
        }
    }

    private static void decodeLightVariableWind(StringBuffer metarAsString, Wind wind) {
        metarAsString.delete(0, 3);
        wind.setVariableWind(true);
        wind.setWindSpeed(Integer.parseInt(metarAsString.substring(0, 2)));
        metarAsString.delete(0, 2);
        WindDecoder.decodeSpeedUnitOfMeasure(metarAsString, wind);
    }

    private static void decodeVariableWindWithGusts(StringBuffer metarAsString, Wind wind) {
        metarAsString.delete(0, 3);
        wind.setVariableWind(true);
        wind.setWindSpeed(Integer.parseInt(metarAsString.substring(0, 2)));
        metarAsString.delete(0, 3);
        wind.setWindSpeedGusts(Integer.parseInt(metarAsString.substring(0, 2)));
        metarAsString.delete(0, 2);
        WindDecoder.decodeSpeedUnitOfMeasure(metarAsString, wind);
    }
}

