/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.taf.util;

import ca.braunit.weatherparser.common.util.WindDecoder;
import ca.braunit.weatherparser.exception.DecoderException;
import ca.braunit.weatherparser.metar.util.CommonDecoder;
import ca.braunit.weatherparser.taf.domain.WindShear;

public class WindShearDecoder {
    private static final String WIND_SHEAR_PATTERN = "((WS[\\d]{3}/[\\d]{5}(KMH|MPS|KT))|(WSCONDS))( |\\Z)(.)*";

    public static WindShear decodeObject(StringBuffer tafAsString) throws DecoderException {
        WindShear windShear = null;
        if (tafAsString.toString().matches(WIND_SHEAR_PATTERN)) {
            windShear = new WindShear();
            if (tafAsString.toString().startsWith("WSCONDS")) {
                windShear.setPotentialWindShear(true);
                CommonDecoder.deleteParsedContent(tafAsString);
            } else {
                tafAsString.delete(0, 2);
                windShear.setAltitude(Integer.parseInt(tafAsString.substring(0, 3)) * 100);
                tafAsString.delete(0, 4);
                windShear.setWind(WindDecoder.decodeObject(tafAsString));
            }
        }
        return windShear;
    }
}

