/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.taf;

import ca.braunit.weatherparser.common.util.CloudsDecoder;
import ca.braunit.weatherparser.common.util.TimeInfoDecoder;
import ca.braunit.weatherparser.common.util.ValidityPeriodDecoder;
import ca.braunit.weatherparser.common.util.VisibilityDecoder;
import ca.braunit.weatherparser.common.util.WeatherDecoder;
import ca.braunit.weatherparser.common.util.WindDecoder;
import ca.braunit.weatherparser.exception.DecoderException;
import ca.braunit.weatherparser.metar.util.CommonDecoder;
import ca.braunit.weatherparser.taf.TafDecoderResult;
import ca.braunit.weatherparser.taf.domain.Taf;
import ca.braunit.weatherparser.taf.util.ExpectedChangeDecoder;
import ca.braunit.weatherparser.taf.util.IcingConditionsDecoder;
import ca.braunit.weatherparser.taf.util.MinimumAltimeterSettingDecoder;
import ca.braunit.weatherparser.taf.util.TemperatureDecoder;
import ca.braunit.weatherparser.taf.util.TurbulenceDecoder;
import ca.braunit.weatherparser.taf.util.WindShearDecoder;

public class TafDecoder {
    private static final String TAF = "TAF";
    private static final String AMD = "AMD";
    private static final String COR = "COR";
    private static final String ICAO_CODE_PATTERN = "[A-Za-z]{4}( |\\Z)(.)*";

    public static TafDecoderResult decodeTaf(String weatherString) throws DecoderException {
        return TafDecoder.decodeObject(new StringBuffer(CommonDecoder.prepareWeatherString(weatherString)));
    }

    private static TafDecoderResult decodeObject(StringBuffer weatherSb) throws DecoderException {
        TafDecoderResult tdResult = new TafDecoderResult();
        Taf taf = new Taf();
        TafDecoder.decodeReportType(taf, weatherSb);
        TafDecoder.decodeAirportIcaoCode(taf, weatherSb);
        taf.setIssuanceTime(TimeInfoDecoder.decodeObject(weatherSb, true));
        taf.setValidityPeriod(ValidityPeriodDecoder.decodeObject(weatherSb));
        while (weatherSb.length() > 0) {
            taf.setWind(WindDecoder.decodeObject(weatherSb));
            taf.setVisibility(VisibilityDecoder.decodeObject(weatherSb));
            taf.setForecastWeather(WeatherDecoder.decodeObject(weatherSb));
            taf.setClouds(CloudsDecoder.decodeObject(weatherSb));
            taf.setIcingConditions(IcingConditionsDecoder.decodeObject(weatherSb));
            taf.setTurbulence(TurbulenceDecoder.decodeObject(weatherSb));
            taf.setWindShear(WindShearDecoder.decodeObject(weatherSb));
            taf.setMinimumAltimeterSettings(MinimumAltimeterSettingDecoder.decodeObject(weatherSb));
            taf.setTemperature(TemperatureDecoder.decodeObject(weatherSb));
            if (taf.getWindShear() == null) {
                taf.setWindShear(WindShearDecoder.decodeObject(weatherSb));
            }
            taf.setExpectedChanges(ExpectedChangeDecoder.decodeObject(weatherSb, tdResult));
            if (weatherSb.length() <= 0) continue;
            tdResult.addUnparsedToken(CommonDecoder.getContentToParse(weatherSb));
            CommonDecoder.deleteParsedContent(weatherSb);
        }
        tdResult.setTaf(taf);
        return tdResult;
    }

    private static void decodeReportType(Taf taf, StringBuffer weatherSb) {
        if (weatherSb.substring(0, TAF.length()).equals(TAF)) {
            weatherSb.delete(0, TAF.length() + 1);
        }
        if (weatherSb.subSequence(0, COR.length()).equals(COR)) {
            taf.setCorrectedReport(true);
            weatherSb.delete(0, COR.length() + 1);
        }
        if (weatherSb.subSequence(0, AMD.length()).equals(AMD)) {
            taf.setUpdateOverPreviousReport(true);
            weatherSb.delete(0, TAF.length() + 1);
        }
    }

    private static void decodeAirportIcaoCode(Taf taf, StringBuffer weatherSb) throws DecoderException {
        if (!weatherSb.toString().matches(ICAO_CODE_PATTERN)) {
            throw new DecoderException("No Airport ICAO Code available");
        }
        taf.setAirportIcaoCode(CommonDecoder.getContentToParse(weatherSb));
        CommonDecoder.deleteParsedContent(weatherSb);
    }
}

