/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.metar.util;

import ca.braunit.weatherparser.metar.domain.RunwayVisualRange;
import ca.braunit.weatherparser.metar.util.CommonDecoder;
import java.util.ArrayList;
import java.util.List;

public class RunwayVisualRangeDecoder {
    private static final String RVR_PATTERN = "R[\\d]{2}(L|R|C)?/(M|P)?[\\d]{4}(FT)?(U|D|N)?(V(M|P)?[\\d]{4}(FT)?(U|D|N)?)?(\\s)(.)*";

    public static List<RunwayVisualRange> decodeObject(StringBuffer metarAsString) {
        ArrayList<RunwayVisualRange> rvrList = new ArrayList<RunwayVisualRange>();
        while (metarAsString.toString().matches(RVR_PATTERN)) {
            RunwayVisualRange rvr = new RunwayVisualRange();
            metarAsString.delete(0, 1);
            rvr.setRunway(metarAsString.substring(0, metarAsString.indexOf("/")));
            metarAsString.delete(0, rvr.getRunway().length() + 1);
            if (metarAsString.substring(0, 1).equals("M")) {
                rvr.setLessThan(true);
                metarAsString.delete(0, 1);
            } else if (metarAsString.substring(0, 1).equals("P")) {
                rvr.setMoreThan(true);
                metarAsString.delete(0, 1);
            }
            rvr.setVisibileRange(Integer.parseInt(metarAsString.substring(0, 4)));
            metarAsString.delete(0, 4);
            RunwayVisualRangeDecoder.checkUnitOfMeasure(rvr, metarAsString);
            if (metarAsString.substring(0, 1).equals("U")) {
                rvr.setUpwardTendency(true);
                metarAsString.delete(0, 1);
            } else if (metarAsString.substring(0, 1).equals("D")) {
                rvr.setDownwardTendency(true);
                metarAsString.delete(0, 1);
            } else if (metarAsString.substring(0, 1).equals("N")) {
                rvr.setNoTendency(true);
                metarAsString.delete(0, 1);
            }
            if (metarAsString.substring(0, 1).equals("V")) {
                metarAsString.delete(0, 1);
                if (metarAsString.substring(0, 1).equals("M")) {
                    rvr.setLessThanVariety(true);
                    metarAsString.delete(0, 1);
                } else if (metarAsString.substring(0, 1).equals("P")) {
                    rvr.setMoreThanVariety(true);
                    metarAsString.delete(0, 1);
                }
                rvr.setVisibileRangeVariety(Integer.parseInt(metarAsString.substring(0, 4)));
                metarAsString.delete(0, 4);
                RunwayVisualRangeDecoder.checkUnitOfMeasure(rvr, metarAsString);
                if (metarAsString.substring(0, 1).equals("U")) {
                    rvr.setUpwardTendencyVariety(true);
                    metarAsString.delete(0, 1);
                } else if (metarAsString.substring(0, 1).equals("D")) {
                    rvr.setDownwardTendencyVariety(true);
                    metarAsString.delete(0, 1);
                } else if (metarAsString.substring(0, 1).equals("N")) {
                    rvr.setNoTendencyVariety(true);
                    metarAsString.delete(0, 1);
                }
            }
            CommonDecoder.deleteParsedContent(metarAsString);
            rvrList.add(rvr);
        }
        return rvrList;
    }

    private static void checkUnitOfMeasure(RunwayVisualRange rvr, StringBuffer metarAsString) {
        if (metarAsString.substring(0, 2).equals("FT")) {
            rvr.setUnitOfMeasure("FT");
            metarAsString.delete(0, 1);
        }
    }
}

