/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.metar.util;

import ca.braunit.weatherparser.metar.domain.WindShear;
import ca.braunit.weatherparser.metar.util.CommonDecoder;
import java.util.ArrayList;
import java.util.List;

public class WindShearDecoder {
    private static final String WIND_SHEAR_PATTERN = "WS ((RWY([\\d]{2}(L|R|C)?))|ALL RWY)( |\\Z)(.)*";

    public static List<WindShear> decodeObject(StringBuffer metarAsString) {
        ArrayList<WindShear> windShearList = new ArrayList<WindShear>();
        while (metarAsString.toString().matches(WIND_SHEAR_PATTERN)) {
            WindShear windShear = new WindShear();
            metarAsString.delete(0, 3);
            if (metarAsString.toString().startsWith("ALL RWY")) {
                windShear.setAllRunways(true);
                metarAsString.delete(0, 7);
            } else {
                metarAsString.delete(0, 3);
                windShear.setRunwayIdentifier(CommonDecoder.getContentToParse(metarAsString));
                CommonDecoder.deleteParsedContent(metarAsString);
            }
            windShearList.add(windShear);
        }
        return windShearList;
    }
}

