/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.metar.util;

import ca.braunit.weatherparser.metar.domain.TemperatureAndDewPoint;
import ca.braunit.weatherparser.metar.util.CommonDecoder;

public class TemperatureAndDewPointDecoder {
    private static final String TEMPERATURE_AND_DEW_POINT_PATTERN = "(M)?(\\d){2}/(M)?(\\d){2}( |\\Z)(.)*";

    public static TemperatureAndDewPoint decodeObject(StringBuffer metarAsString) {
        TemperatureAndDewPoint tad = null;
        if (metarAsString.toString().matches(TEMPERATURE_AND_DEW_POINT_PATTERN)) {
            tad = new TemperatureAndDewPoint();
            int multiplier = 1;
            if (metarAsString.toString().startsWith("M")) {
                metarAsString.delete(0, 1);
                multiplier = -1;
            }
            tad.setTemperature(Integer.parseInt(metarAsString.substring(0, 2)) * multiplier);
            metarAsString.delete(0, 3);
            if (metarAsString.toString().startsWith("M")) {
                metarAsString.delete(0, 1);
                multiplier = -1;
            } else {
                multiplier = 1;
            }
            tad.setDewPoint(Integer.parseInt(metarAsString.substring(0, 2)) * multiplier);
            CommonDecoder.deleteParsedContent(metarAsString);
        }
        return tad;
    }
}

