/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.metar;

import ca.braunit.weatherparser.common.util.CloudsDecoder;
import ca.braunit.weatherparser.common.util.TimeInfoDecoder;
import ca.braunit.weatherparser.common.util.VisibilityDecoder;
import ca.braunit.weatherparser.common.util.WeatherDecoder;
import ca.braunit.weatherparser.common.util.WindDecoder;
import ca.braunit.weatherparser.exception.DecoderException;
import ca.braunit.weatherparser.metar.MetarDecoderResult;
import ca.braunit.weatherparser.metar.domain.Metar;
import ca.braunit.weatherparser.metar.util.CommonDecoder;
import ca.braunit.weatherparser.metar.util.PressureDecoder;
import ca.braunit.weatherparser.metar.util.RemarksDecoder;
import ca.braunit.weatherparser.metar.util.RunwayVisualRangeDecoder;
import ca.braunit.weatherparser.metar.util.TemperatureAndDewPointDecoder;
import ca.braunit.weatherparser.metar.util.WindShearDecoder;

public class MetarDecoder {
    private static final String METAR = "METAR";
    private static final String SPECI = "SPECI";
    private static final String CORRECTED = "COR";
    private static final String AUTOMATED_OBSERVATION = "AUTO";
    private static final String ICAO_CODE_PATTERN = "[A-Za-z]{4}( |\\Z)(.)*";

    public static MetarDecoderResult decodeMetar(String weatherString) throws DecoderException {
        return MetarDecoder.decodeObject(new StringBuffer(CommonDecoder.prepareWeatherString(weatherString)));
    }

    private static MetarDecoderResult decodeObject(StringBuffer weatherSb) throws DecoderException {
        MetarDecoderResult mdResult = new MetarDecoderResult();
        Metar metar = new Metar();
        MetarDecoder.deodeReportType(metar, weatherSb);
        MetarDecoder.decodeAirportIcaoCode(metar, weatherSb);
        metar.setReportTime(TimeInfoDecoder.decodeObject(weatherSb, true));
        MetarDecoder.decodeAutomatedObservation(metar, weatherSb);
        while (weatherSb.length() > 0) {
            metar.setWind(WindDecoder.decodeObject(weatherSb));
            metar.setVisibility(VisibilityDecoder.decodeObject(weatherSb));
            metar.setRunwayVisualRanges(RunwayVisualRangeDecoder.decodeObject(weatherSb));
            metar.setPresentWeather(WeatherDecoder.decodeObject(weatherSb));
            metar.setClouds(CloudsDecoder.decodeObject(weatherSb));
            metar.setTemperatureAndDewPoint(TemperatureAndDewPointDecoder.decodeObject(weatherSb));
            metar.setPressure(PressureDecoder.decodeObject(weatherSb));
            metar.setRecentWeather(WeatherDecoder.decodeObject(weatherSb));
            metar.setWindShear(WindShearDecoder.decodeObject(weatherSb));
            metar.setRemarks(RemarksDecoder.decodeObject(weatherSb));
            if (weatherSb.length() <= 0) continue;
            mdResult.addUnparsedToken(CommonDecoder.getContentToParse(weatherSb));
            CommonDecoder.deleteParsedContent(weatherSb);
        }
        mdResult.setMetar(metar);
        return mdResult;
    }

    private static void deodeReportType(Metar metar, StringBuffer weatherSb) {
        if (weatherSb.toString().startsWith(CORRECTED)) {
            metar.setCorrectedReport(true);
            CommonDecoder.deleteParsedContent(weatherSb);
        }
        if (weatherSb.substring(0, METAR.length()).equals(METAR)) {
            metar.setMetarType(true);
            weatherSb.delete(0, METAR.length() + 1);
        } else if (weatherSb.substring(0, SPECI.length()).equals(SPECI)) {
            metar.setSpeciType(true);
            weatherSb.delete(0, SPECI.length() + 1);
        } else {
            metar.setMetarType(true);
        }
    }

    private static void decodeAirportIcaoCode(Metar metar, StringBuffer weatherSb) throws DecoderException {
        if (!weatherSb.toString().matches(ICAO_CODE_PATTERN)) {
            throw new DecoderException("No Airport ICAO Code available");
        }
        metar.setAirportIcaoCode(CommonDecoder.getContentToParse(weatherSb));
        CommonDecoder.deleteParsedContent(weatherSb);
    }

    private static void decodeAutomatedObservation(Metar metar, StringBuffer weatherSb) {
        if (weatherSb.substring(0, AUTOMATED_OBSERVATION.length()).equals(AUTOMATED_OBSERVATION)) {
            metar.setAutomatedObservation(true);
            weatherSb.delete(0, AUTOMATED_OBSERVATION.length() + 1);
        }
    }
}

