/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.taf.util;

import ca.braunit.weatherparser.metar.domain.Pressure;
import ca.braunit.weatherparser.metar.util.CommonDecoder;

public class MinimumAltimeterSettingDecoder {
    private static final String PRESSURE_PATTERN = "QNH(\\d){4}INS( |\\Z)(.)*";

    public static Pressure decodeObject(StringBuffer tafAsString) {
        Pressure pressure = null;
        if (tafAsString.toString().matches(PRESSURE_PATTERN)) {
            pressure = new Pressure();
            pressure.setPressure((int)Math.round(Double.parseDouble(tafAsString.substring(3, 7)) / 100.0 / 0.02953));
            CommonDecoder.deleteParsedContent(tafAsString);
        }
        return pressure;
    }
}

