/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.metar.util;

import ca.braunit.weatherparser.metar.domain.Pressure;
import ca.braunit.weatherparser.metar.util.CommonDecoder;

public class PressureDecoder {
    private static final String PRESSURE_PATTERN = "(Q|A)(\\d){4}(.)*";

    public static Pressure decodeObject(StringBuffer metarAsString) {
        Pressure pressure = null;
        if (metarAsString.toString().matches(PRESSURE_PATTERN)) {
            pressure = new Pressure();
            if (metarAsString.toString().startsWith("Q")) {
                pressure.setPressure(Integer.parseInt(metarAsString.substring(1, 5)));
            } else {
                pressure.setPressure((int)Math.round(Double.parseDouble(metarAsString.substring(1, 5)) / 100.0 / 0.02953));
            }
            CommonDecoder.deleteParsedContent(metarAsString);
        }
        return pressure;
    }
}

