/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.common.util;

import ca.braunit.weatherparser.common.domain.Visibility;
import ca.braunit.weatherparser.metar.util.CommonDecoder;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;

public class VisibilityDecoder {
    private static final String NDV_STRING = "NDV";
    private static final String CAVOK_PATTERN = "(CAVOK)(.)*";
    private static final String STANDARD_VISIBILITY_PATTERN = "[\\d]{4}(\\s|\\Z|NDV)(.)*";
    private static final String STANDARD_WITH_DIRECTION_VISIBILITY_PATTERN = "[\\d]{4}(N|NW|W|SW|S|SE|E|NE)(.)*";
    private static final String STATUTE_MILE_VISIBILITY_PATTERN = "(P)?[\\d]{1,4}SM(.)*";
    private static final String STATUTE_MILE_FRACTION_VISIBILITY_PATTERN = "([\\d] )?[\\d]/[\\d]SM(.)*";

    public static List<Visibility> decodeObject(StringBuffer metarAsString) {
        ArrayList<Visibility> visibilityList = new ArrayList<Visibility>();
        Visibility visibility = null;
        do {
            visibility = null;
            if (metarAsString.toString().matches(CAVOK_PATTERN)) {
                visibility = new Visibility();
                visibility.setCavok(true);
                metarAsString.delete(0, "CAVOK".length() + 1);
            } else if (metarAsString.toString().matches(STATUTE_MILE_VISIBILITY_PATTERN)) {
                visibility = new Visibility();
                if (metarAsString.toString().startsWith("P")) {
                    visibility.setGreaterThan(true);
                    metarAsString.delete(0, 1);
                }
                String visibilityString = metarAsString.substring(0, metarAsString.indexOf("SM"));
                visibility.setVisibility(new BigDecimal(visibilityString));
                metarAsString.delete(0, visibilityString.length() + 3);
                visibility.setVisibilityUnitOfMeasure("SM");
            } else if (metarAsString.toString().matches(STANDARD_VISIBILITY_PATTERN)) {
                visibility = new Visibility();
                if (metarAsString.substring(0, 4).equals("9999")) {
                    visibility.setVisibility(new BigDecimal("10000"));
                    visibility.setGreaterThan(true);
                } else {
                    visibility.setVisibility(new BigDecimal(metarAsString.substring(0, 4)));
                }
                metarAsString.delete(0, 4);
                if (metarAsString.length() >= 3 && metarAsString.substring(0, 3).equals(NDV_STRING)) {
                    visibility.setNdv(true);
                }
                CommonDecoder.deleteParsedContent(metarAsString);
            } else if (metarAsString.toString().matches(STANDARD_WITH_DIRECTION_VISIBILITY_PATTERN)) {
                visibility = new Visibility();
                visibility.setVisibility(new BigDecimal(metarAsString.substring(0, 4)));
                metarAsString.delete(0, 4);
                visibility.setDirection(CommonDecoder.getContentToParse(metarAsString));
                CommonDecoder.deleteParsedContent(metarAsString);
            } else if (metarAsString.toString().matches(STATUTE_MILE_FRACTION_VISIBILITY_PATTERN)) {
                visibility = new Visibility();
                BigDecimal additionalStatuteMiles = BigDecimal.ZERO;
                if (" ".equals(metarAsString.substring(1, 2))) {
                    additionalStatuteMiles = new BigDecimal(CommonDecoder.getContentToParse(metarAsString));
                    CommonDecoder.deleteParsedContent(metarAsString);
                }
                BigDecimal numerator = new BigDecimal(metarAsString.substring(0, metarAsString.indexOf("/")));
                BigDecimal divisor = new BigDecimal(metarAsString.substring(metarAsString.indexOf("/") + 1, metarAsString.indexOf("SM")));
                visibility.setVisibility(numerator.divide(divisor, MathContext.DECIMAL32).add(additionalStatuteMiles));
                CommonDecoder.deleteParsedContent(metarAsString);
                visibility.setVisibilityUnitOfMeasure("SM");
            }
            if (visibility == null) continue;
            visibilityList.add(visibility);
        } while (visibility != null);
        return visibilityList;
    }
}

