/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.taf.util;

import ca.braunit.weatherparser.common.domain.TimeInfo;
import ca.braunit.weatherparser.metar.util.CommonDecoder;
import ca.braunit.weatherparser.taf.domain.Temperature;

public class TemperatureDecoder {
    private static final String TEMPERATURE_PATTERN = "T(M)?(\\d){2}/(\\d){4}(z|Z)( |\\Z)(.)*";

    public static Temperature decodeObject(StringBuffer tafAsString) {
        Temperature temperature = null;
        if (tafAsString.toString().matches(TEMPERATURE_PATTERN)) {
            temperature = new Temperature();
            tafAsString.delete(0, 1);
            int multiplier = 1;
            if (tafAsString.toString().startsWith("M")) {
                multiplier = -1;
                tafAsString.delete(0, 1);
            }
            temperature.setTemperature(Integer.parseInt(tafAsString.substring(0, 2)) * multiplier);
            tafAsString.delete(0, 3);
            TimeInfo time = new TimeInfo();
            time.setDayOfMonth(Integer.parseInt(tafAsString.substring(0, 2)));
            tafAsString.delete(0, 2);
            time.setHour(Integer.parseInt(tafAsString.substring(0, 2)));
            time.setMinute(0);
            temperature.setTime(time);
            CommonDecoder.deleteParsedContent(tafAsString);
        }
        return temperature;
    }
}

