/*
 * Decompiled with CFR 0.152.
 */
package ca.braunit.weatherparser.taf.util;

import ca.braunit.weatherparser.exception.DecoderException;
import ca.braunit.weatherparser.metar.util.CommonDecoder;
import ca.braunit.weatherparser.taf.domain.IcingConditions;
import java.util.HashMap;
import java.util.Map;

public class IcingConditionsDecoder {
    private static final String ICING_CONDITIONS_PATTERN = "6[\\d]{5}( |\\Z)(.)*";
    private static final Map<Integer, String> INTENSITY_MAP = new HashMap<Integer, String>();

    public static IcingConditions decodeObject(StringBuffer tafAsString) throws DecoderException {
        IcingConditions icingConditions = null;
        if (tafAsString.toString().matches(ICING_CONDITIONS_PATTERN)) {
            icingConditions = new IcingConditions();
            tafAsString.delete(0, 1);
            icingConditions.setIcingIntensityCode(Integer.parseInt(tafAsString.substring(0, 1)));
            icingConditions.setIcingIntensity(INTENSITY_MAP.get(icingConditions.getIcingIntensityCode()));
            tafAsString.delete(0, 1);
            icingConditions.setIcingLayerBase(Integer.parseInt(tafAsString.substring(0, 3)) * 100);
            tafAsString.delete(0, 3);
            icingConditions.setIcingLayerDepth(Integer.parseInt(tafAsString.substring(0, 1)) * 1000);
            CommonDecoder.deleteParsedContent(tafAsString);
        }
        return icingConditions;
    }

    static {
        INTENSITY_MAP.put(0, "no icing / trace of icing");
        INTENSITY_MAP.put(1, "light mixed icing");
        INTENSITY_MAP.put(2, "light rime icing in cloud");
        INTENSITY_MAP.put(3, "light clear icing in precipitation");
        INTENSITY_MAP.put(4, "moderate mixed icing");
        INTENSITY_MAP.put(5, "moderate rime icing in cloud");
        INTENSITY_MAP.put(6, "moderate clear icing in precipitation");
        INTENSITY_MAP.put(7, "severe mixed icing");
        INTENSITY_MAP.put(8, "severe rime icing in cloud");
        INTENSITY_MAP.put(9, "severe clear icing in precipitation");
    }
}

