/*
 * Copyright (c)2014 Braun IT Solutions Ltd, Vancouver, Canada
 * http://www.braun-it.ca
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package ca.braunit.weatherparser.metar.util;

public class CommonDecoder {

	public static void deleteParsedContent(StringBuffer sb) {
		if (sb.toString().contains(" ")) {
			sb.delete(0, sb.indexOf(" ") + 1);
		} else {
			sb.delete(0, sb.length());
		}
	}

	public static String getContentToParse(StringBuffer sb) {
		
		if (sb.length() == 0) {
			return null;
		} else if (sb.indexOf(" ") > -1) {
			return sb.substring(0, sb.indexOf(" "));
		} else {
			return sb.toString();
		}
	}
	
	public static String prepareWeatherString(String sourceWeatherString) {
		return sourceWeatherString.replaceAll("(\\s)++", " ").trim();
	}
}
