/*
 * Decompiled with CFR 0.152.
 */
package ca.antonious.viewcelladapter.compiler;

import ca.antonious.viewcelladapter.compiler.BindListenerSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class BindListenersSpec {
    private String viewCellClassName;
    private PackageElement packageElement;
    private TypeName viewCellTypeName;
    private TypeName viewHolderTypeName;
    private TypeName listenerCollectionTypeName;
    private TypeName bindListenersInterfaceName;
    private List<BindListenerSpec> bindListenerSpecs = new ArrayList<BindListenerSpec>();
    private static final String LISTENER_BINDER_SUFFIX = "_ListenerBinder";
    private static final String BIND_LISTENERS_METHOD_NAME = "bindListeners";
    private static final String VIEW_CELL_VARIABLE_NAME = "viewCell";
    private static final String VIEW_HOLDER_VARIABLE_NAME = "viewHolder";
    private static final String LISTENER_COLLECTION_VARIABLE_NAME = "listenerCollection";

    private BindListenersSpec(TypeElement viewCellElement, TypeMirror viewHolderType, List<? extends BindListenerSpec> bindListenerSpecs) {
        this.bindListenerSpecs.addAll(bindListenerSpecs);
        this.viewCellClassName = viewCellElement.getSimpleName().toString();
        this.packageElement = (PackageElement)viewCellElement.getEnclosingElement();
        this.viewCellTypeName = ClassName.get((TypeMirror)viewCellElement.asType());
        this.viewHolderTypeName = ClassName.get((TypeMirror)viewHolderType);
        this.listenerCollectionTypeName = ClassName.get((String)"ca.antonious.viewcelladapter.viewcells.eventhandling", (String)"ListenerCollection", (String[])new String[0]);
        ClassName listenerBinderClassName = ClassName.get((String)"ca.antonious.viewcelladapter.viewcells.eventhandling", (String)"ListenerBinder", (String[])new String[0]);
        this.bindListenersInterfaceName = ParameterizedTypeName.get((ClassName)listenerBinderClassName, (TypeName[])new TypeName[]{this.viewCellTypeName, this.viewHolderTypeName});
    }

    public JavaFile buildJavaFile() {
        return JavaFile.builder((String)this.getPackageName(), (TypeSpec)this.buildType()).addFileComment("Generated code by ViewCellAdapter. Do not modify!", new Object[0]).build();
    }

    private TypeSpec buildType() {
        return TypeSpec.classBuilder((String)(this.viewCellClassName + LISTENER_BINDER_SUFFIX)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(this.bindListenersInterfaceName).addMethod(this.buildBindListenersMethod()).build();
    }

    private MethodSpec buildBindListenersMethod() {
        MethodSpec.Builder methodSignatureBuilder = this.buildBindListenersMethodSignature();
        return this.buildBindListenersMethodBody(methodSignatureBuilder).build();
    }

    private MethodSpec.Builder buildBindListenersMethodSignature() {
        return MethodSpec.methodBuilder((String)BIND_LISTENERS_METHOD_NAME).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.viewCellTypeName, VIEW_CELL_VARIABLE_NAME, new Modifier[0]).addParameter(this.viewHolderTypeName, VIEW_HOLDER_VARIABLE_NAME, new Modifier[0]).addParameter(this.listenerCollectionTypeName, LISTENER_COLLECTION_VARIABLE_NAME, new Modifier[0]);
    }

    private MethodSpec.Builder buildBindListenersMethodBody(MethodSpec.Builder methodBuilder) {
        for (int i = 0; i < this.bindListenerSpecs.size(); ++i) {
            BindListenerSpec bindListenerSpec = this.bindListenerSpecs.get(i);
            TypeName listener = ClassName.get((TypeMirror)bindListenerSpec.getListenerType());
            methodBuilder = methodBuilder.addCode("\n", new Object[0]).addStatement("$T listener$L = $N.getListener($T.class)", new Object[]{listener, i, LISTENER_COLLECTION_VARIABLE_NAME, listener}).beginControlFlow("if (listener$L != null)", new Object[]{i}).addStatement("$N.$N($N, $N)", new Object[]{VIEW_CELL_VARIABLE_NAME, bindListenerSpec.getBindListenerMethodName(), VIEW_HOLDER_VARIABLE_NAME, "listener" + i}).endControlFlow();
        }
        return methodBuilder;
    }

    private String getPackageName() {
        return this.packageElement.getQualifiedName().toString();
    }

    public String toString() {
        return this.buildJavaFile().toString();
    }

    public static class Builder {
        private TypeElement classElement;
        private TypeElement viewHolderElement;
        private List<BindListenerSpec> bindListenerSpecs;

        public Builder(TypeElement classElement, TypeElement viewCellElement) {
            this.classElement = classElement;
            this.viewHolderElement = viewCellElement;
            this.bindListenerSpecs = new ArrayList<BindListenerSpec>();
        }

        public TypeElement getViewHolderElement() {
            return this.viewHolderElement;
        }

        public BindListenersSpec build() {
            return new BindListenersSpec(this.classElement, this.viewHolderElement.asType(), this.bindListenerSpecs);
        }

        public Builder addListener(BindListenerSpec bindListenerSpec) {
            this.bindListenerSpecs.add(bindListenerSpec);
            return this;
        }
    }
}

