/*
 * Decompiled with CFR 0.152.
 */
package ca.antonious.viewcelladapter.compiler;

import ca.antonious.viewcelladapter.annotations.BindListener;
import ca.antonious.viewcelladapter.compiler.BaseProcessor;
import ca.antonious.viewcelladapter.compiler.BindListenerSpec;
import ca.antonious.viewcelladapter.compiler.BindListenersSpec;
import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

@AutoService(value=Processor.class)
public class BindListenerProcessor
extends BaseProcessor {
    private TypeElement abstractViewCellTypeElement;
    private Map<TypeElement, BindListenersSpec.Builder> bindListenersSpecBuilders;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.abstractViewCellTypeElement = this.elementUtils.getTypeElement("ca.antonious.viewcelladapter.viewcells.AbstractViewCell");
        this.bindListenersSpecBuilders = new HashMap<TypeElement, BindListenersSpec.Builder>();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(BindListener.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        this.findAndParseBindListeners(roundEnvironment);
        this.generateSourceFiles(this.bindListenersSpecBuilders);
        this.clearFoundListeners();
        return true;
    }

    private void generateSourceFiles(Map<TypeElement, BindListenersSpec.Builder> bindListenersSpecBuilders) {
        for (Map.Entry<TypeElement, BindListenersSpec.Builder> entry : bindListenersSpecBuilders.entrySet()) {
            try {
                entry.getValue().build().buildJavaFile().writeTo(this.processingEnv.getFiler());
            }
            catch (Exception e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage(), entry.getKey());
            }
        }
    }

    private void findAndParseBindListeners(RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(BindListener.class)) {
            TypeElement viewCellType = (TypeElement)element.getEnclosingElement();
            BindListenersSpec.Builder bindListenersSpecBuilder = this.getOrCreateBindListenersSpecBuilder(viewCellType);
            try {
                ExecutableElement methodElement = (ExecutableElement)element;
                this.visitMethod(methodElement, bindListenersSpecBuilder);
            }
            catch (Exception e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage(), element);
            }
        }
    }

    private void clearFoundListeners() {
        this.bindListenersSpecBuilders.clear();
    }

    private BindListenersSpec.Builder getOrCreateBindListenersSpecBuilder(TypeElement viewCellType) {
        if (!this.bindListenersSpecBuilders.containsKey(viewCellType)) {
            BindListenersSpec.Builder specBuilder = this.createBindListenersSpecBuilder(viewCellType);
            this.bindListenersSpecBuilders.put(viewCellType, specBuilder);
        }
        return this.bindListenersSpecBuilders.get(viewCellType);
    }

    private BindListenersSpec.Builder createBindListenersSpecBuilder(TypeElement viewCellType) {
        DeclaredType declaredViewCell = (DeclaredType)viewCellType.asType();
        DeclaredType declaredAbstractViewCell = this.getAbstractViewHolderDeclaration(declaredViewCell);
        this.guardAgainstUsageInNonViewCellClasses(viewCellType, declaredAbstractViewCell);
        TypeElement viewHolderType = this.getGenericViewHolderType(declaredAbstractViewCell);
        return new BindListenersSpec.Builder(viewCellType, viewHolderType);
    }

    private void guardAgainstUsageInNonViewCellClasses(TypeElement typeElement, DeclaredType declaredAbstractViewCell) {
        if (declaredAbstractViewCell == null) {
            String badClassName = typeElement.getQualifiedName().toString();
            String abstractViewCellName = this.abstractViewCellTypeElement.getSimpleName().toString();
            String errorTemplate = "%s with method annotated with @BindListener is not a subclass of %s.";
            String errorMessage = String.format(Locale.getDefault(), errorTemplate, badClassName, abstractViewCellName);
            throw new IllegalStateException(errorMessage);
        }
    }

    private void visitMethod(ExecutableElement methodElement, BindListenersSpec.Builder specBuilder) {
        this.guardAgainstPrivateMethod(methodElement);
        this.guardAgainstIncorrectParameterSize(methodElement, specBuilder);
        this.guardAgainstIllegalViewHolderType(methodElement, specBuilder);
        String methodName = methodElement.getSimpleName().toString();
        VariableElement listenerVariable = methodElement.getParameters().get(1);
        TypeMirror listenerType = listenerVariable.asType();
        specBuilder.addListener(new BindListenerSpec(methodName, listenerType));
    }

    private void guardAgainstPrivateMethod(ExecutableElement methodElement) {
        if (methodElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            String errorMessage = "Methods with @BindListener should not be private.";
            throw new IllegalStateException(errorMessage);
        }
    }

    private void guardAgainstIncorrectParameterSize(ExecutableElement methodElement, BindListenersSpec.Builder specBuilder) {
        int parametersSize = methodElement.getParameters().size();
        if (parametersSize != 2) {
            String viewHolderName = specBuilder.getViewHolderElement().getQualifiedName().toString();
            String errorTemplate = "Expected two arguments of type %s, java.lang.Object for method annotated with @BindListener, but found %d argument(s).";
            String errorMessage = String.format(Locale.getDefault(), errorTemplate, viewHolderName, parametersSize);
            throw new IllegalStateException(errorMessage);
        }
    }

    private void guardAgainstIllegalViewHolderType(ExecutableElement methodElement, BindListenersSpec.Builder specBuilder) {
        TypeMirror viewHolderType = methodElement.getParameters().get(0).asType();
        TypeMirror viewHolderConstraintType = specBuilder.getViewHolderElement().asType();
        if (!this.isTypeSubtypeOf(viewHolderConstraintType, viewHolderType)) {
            String actualViewHolderName = ((TypeElement)this.typeUtils.asElement(viewHolderType)).getQualifiedName().toString();
            String expectedViewHolderName = specBuilder.getViewHolderElement().getQualifiedName().toString();
            String errorTemplate = "Expected first argument for method annotated with @BindListener to have a lower bound of type %s, but found %s.";
            String errorMessage = String.format(Locale.getDefault(), errorTemplate, expectedViewHolderName, actualViewHolderName);
            throw new IllegalStateException(errorMessage);
        }
    }

    private TypeElement getGenericViewHolderType(DeclaredType declaredAbstractViewCell) {
        List<? extends TypeMirror> typeParameters = declaredAbstractViewCell.getTypeArguments();
        return (TypeElement)this.typeUtils.asElement(typeParameters.get(0));
    }

    private DeclaredType getAbstractViewHolderDeclaration(DeclaredType declaredViewCell) {
        do {
            if (!this.hasSupertype(declaredViewCell)) {
                return null;
            }
            declaredViewCell = this.getSuperclassTypeOf(declaredViewCell);
        } while (!this.isTypeEqualTo(this.abstractViewCellTypeElement.asType(), declaredViewCell.asElement().asType()));
        return declaredViewCell;
    }
}

