/*
 * Decompiled with CFR 0.152.
 */
package ca.antonious.viewcelladapter.compiler;

import java.util.PriorityQueue;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class BaseProcessor
extends AbstractProcessor {
    protected Types typeUtils;
    protected Elements elementUtils;
    protected Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.typeUtils = this.processingEnv.getTypeUtils();
        this.elementUtils = this.processingEnv.getElementUtils();
        this.messager = this.processingEnv.getMessager();
    }

    public boolean isTypeEqualTo(TypeMirror type1, TypeMirror type2) {
        return type1.toString().equals(type2.toString());
    }

    public boolean isTypeSubtypeOf(TypeMirror type, TypeMirror parentType) {
        PriorityQueue<? extends TypeMirror> typesToCheck = new PriorityQueue<TypeMirror>();
        typesToCheck.add(type);
        while (!typesToCheck.isEmpty()) {
            TypeMirror currentType = (TypeMirror)typesToCheck.remove();
            if (this.isTypeEqualTo(currentType, parentType)) {
                return true;
            }
            typesToCheck.addAll(this.typeUtils.directSupertypes(currentType));
        }
        return false;
    }

    public boolean hasSupertype(DeclaredType declaredType) {
        return !this.typeUtils.directSupertypes(declaredType).isEmpty();
    }

    public DeclaredType getSuperclassTypeOf(DeclaredType declaredType) {
        TypeMirror superClass = this.typeUtils.directSupertypes(declaredType).get(0);
        return (DeclaredType)superClass;
    }
}

