package by.shostko.android.rxlifecycle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import io.reactivex.Emitter;

import static androidx.annotation.RestrictTo.Scope.LIBRARY;

@RestrictTo(LIBRARY)
@SuppressWarnings("unused")
final class LifecycleStateObserver implements LifecycleObserver {

    @NonNull
    private final Lifecycle lifecycle;

    @Nullable
    private EmitterWrapper<Lifecycle.State> emitter;

    LifecycleStateObserver(@NonNull Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    void setEmitter(@Nullable Emitter<Lifecycle.State> emitter) {
        this.emitter = new EmitterWrapper<>(emitter);
    }

    @OnLifecycleEvent(Lifecycle.Event.ON_ANY)
    public void onAny() {
        if (emitter != null) {
            emitter.tryEmit(lifecycle.getCurrentState());
        }
    }
}