package by.shostko.android.rxlifecycle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import io.reactivex.*;

import static androidx.annotation.RestrictTo.Scope.LIBRARY;

@RestrictTo(LIBRARY)
@SuppressWarnings("unused")
class EmitterWrapper<T> {

    @Nullable
    private final Emitter<T> emitter;

    EmitterWrapper(@Nullable Emitter<T> emitter) {
        this.emitter = emitter;
    }

    void tryEmit(@NonNull T value) {
        if (emitter != null && canEmit()) {
            emitter.onNext(value);
        }
    }

    private boolean canEmit() {
        if (emitter instanceof FlowableEmitter) {
            return !((FlowableEmitter) emitter).isCancelled();
        } else if (emitter instanceof ObservableEmitter) {
            return !((ObservableEmitter) emitter).isDisposed();
        } else if (emitter instanceof SingleEmitter) {
            return !((SingleEmitter) emitter).isDisposed();
        } else if (emitter instanceof MaybeEmitter) {
            return !((MaybeEmitter) emitter).isDisposed();
        } else if (emitter instanceof CompletableEmitter) {
            return !((CompletableEmitter) emitter).isDisposed();
        } else {
            return false;
        }
    }
}
