/*
 * Decompiled with CFR 0.152.
 */
package by.legan.library.netengine.network.server;

import by.legan.library.netengine.controller.NetServerController;
import by.legan.library.netengine.interfaces.Logs;
import by.legan.library.netengine.network.Network;
import by.legan.library.netengine.network.packeges.clientTOserver.ClientMessage;
import by.legan.library.netengine.network.server.AbstractServer;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.EndPoint;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.Server;

public class NetServer
extends AbstractServer {
    Server server = new Server(256000, 256000){

        protected Connection newConnection() {
            NetServer.this.status = AbstractServer.NetServerStatus.online;
            SConnection connection = new SConnection();
            connection.name = "client";
            NetServer.this.netServerListener.netServerMessage(connection.getID(), new ClientMessage.NewClientConnect());
            return connection;
        }
    };

    public NetServer(NetServerController netServerController) {
        super(netServerController);
        Network.register((EndPoint)this.server, netServerController.classArrayList);
        this.server.addListener(new Listener(){

            public void received(Connection connection, Object object) {
                SConnection connect = (SConnection)connection;
                NetServer.this.netServerListener.netServerMessage(connect.getID(), object);
            }

            public void disconnected(Connection connection) {
                SConnection conn = (SConnection)connection;
                NetServer.this.netServerListener.netServerMessage(conn.getID(), new ClientMessage.ClientDisconnect(conn.getID()));
            }
        });
    }

    public boolean start() {
        try {
            this.server.bind(Network.portTCP, Network.portUDP);
            this.server.start();
            return true;
        }
        catch (Exception e) {
            Logs.out("ERROR Server already running");
            return false;
        }
    }

    @Override
    public int getCollClient() {
        return this.server.getConnections().length;
    }

    public Connection[] getConnections() {
        return this.server.getConnections();
    }

    @Override
    public void dispose() {
        this.server.stop();
        Logs.out("NetServer stopped and dispose");
    }

    @Override
    public void sendToAllUDP(Object message) {
        this.server.sendToAllUDP(message);
    }

    @Override
    public void sendToAllTCP(Object message) {
        this.server.sendToAllTCP(message);
    }

    @Override
    public void sendtoTCP(int connectionID, Object message) {
        this.server.sendToTCP(connectionID, message);
    }

    @Override
    public void sendtoUDP(int connectionID, Object message) {
        this.server.sendToUDP(connectionID, message);
    }

    static class SConnection
    extends Connection {
        public String name;

        SConnection() {
        }
    }
}

